/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
import { runtimeMsg } from '../internal/runtime-msg.js';
import { _installMsgImplementation } from './install.js';
/**
 * Set configuration parameters for lit-localize when in reentrant mode.
 *
 * Throws if called more than once.
 */
export const configureReentrantLocalization = ({ sourceLocale, targetLocales, getLocale, loadLocaleSync, }) => {
    const targetLocalesSet = new Set(targetLocales);
    _installMsgImplementation(((template, options) => {
        const locale = getLocale();
        const templates = locale !== sourceLocale && targetLocalesSet.has(locale)
            ? loadLocaleSync(locale)?.templates
            : undefined;
        return runtimeMsg(templates, template, options);
    }));
    return {};
};
//# sourceMappingURL=reentrant.js.map