/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.tcp.TcpConnector;

public class TcpSocketKey {
    private InetSocketAddress address;
    private ImmutableEndpoint endpoint;

    public TcpSocketKey(ImmutableEndpoint endpoint) {
        if (!(endpoint.getConnector() instanceof TcpConnector)) {
            throw new IllegalArgumentException("Sockets must be keyed via a TCP endpoint");
        }
        this.endpoint = endpoint;
        this.address = new InetSocketAddress(endpoint.getEndpointURI().getHost(), endpoint.getEndpointURI().getPort());
    }

    public boolean equals(Object obj) {
        return obj instanceof TcpSocketKey && this.address.equals(((TcpSocketKey)obj).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public TcpConnector getConnector() {
        return (TcpConnector)this.endpoint.getConnector();
    }

    public InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String toString() {
        return this.getInetAddress() + ":" + this.getPort();
    }
}

