/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.transformers;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.jms.transformers.AbstractJmsTransformer;
import org.mule.util.ClassUtils;

public class JMSMessageToObject
extends AbstractJmsTransformer {
    @Override
    protected void declareInputOutputClasses() {
        this.registerSourceType(DataTypeFactory.create(Message.class));
        this.registerSourceType(DataTypeFactory.create(TextMessage.class));
        this.registerSourceType(DataTypeFactory.create(ObjectMessage.class));
        this.registerSourceType(DataTypeFactory.create(BytesMessage.class));
        this.registerSourceType(DataTypeFactory.create(MapMessage.class));
        this.registerSourceType(DataTypeFactory.create(StreamMessage.class));
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Source object is " + ClassUtils.getSimpleName(message.getPayload().getClass())));
            }
            Object result = this.transformFromMessage((Message)message.getPayload(), outputEncoding);
            if (this.returnType.getType().equals(byte[].class) && result instanceof String) {
                result = result.toString().getBytes(outputEncoding);
            } else if (this.returnType.getType().equals(String.class) && result instanceof byte[]) {
                result = new String((byte[])result, outputEncoding);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resulting object is " + ClassUtils.getSimpleName(result.getClass())));
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

