/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import org.mule.config.spring.factories.InboundEndpointFactoryBean;
import org.mule.config.spring.factories.OutboundEndpointFactoryBean;
import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PrefixValueMap;
import org.mule.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.specific.FilterDefinitionParser;
import org.mule.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.mule.config.spring.parsers.specific.TransactionDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportGlobalEndpointDefinitionParser;
import org.mule.transport.jms.JmsClientAcknowledgeTransactionFactory;
import org.mule.transport.jms.JmsTransactionFactory;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.activemq.ActiveMQXAJmsConnector;
import org.mule.transport.jms.config.JmsConnectorDefinitionParser;
import org.mule.transport.jms.config.MuleMQConnectorDefinitionParser;
import org.mule.transport.jms.filters.JmsPropertyFilter;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.jndi.SimpleJndiNameResolver;
import org.mule.transport.jms.mulemq.MuleMQJmsConnector;
import org.mule.transport.jms.mulemq.MuleMQXAJmsConnector;
import org.mule.transport.jms.transformers.JMSMessageToObject;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;
import org.mule.transport.jms.weblogic.WeblogicJmsConnector;
import org.mule.transport.jms.websphere.WebsphereJmsConnector;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class JmsNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";
    public static final String NUMBER_OF_CONSUMERS_ATTRIBUTE = "numberOfConsumers";
    public static final String NUMBER_OF_CONCURRENT_TRANSACTED_RECEIVERS_ATTRIBUTE = "numberOfConcurrentTransactedReceivers";
    public static final String NUMBER_OF_CONSUMERS_PROPERTY = "numberOfConcurrentTransactedReceivers";
    public static final String[][] JMS_ATTRIBUTES = new String[][]{{"queue"}, {"topic"}};

    public void init() {
        this.registerJmsTransportEndpoints();
        this.registerMuleBeanDefinitionParser("connector", (MuleDefinitionParser)new JmsConnectorDefinitionParser()).addAlias(NUMBER_OF_CONSUMERS_ATTRIBUTE, "numberOfConcurrentTransactedReceivers").registerPreProcessor((PreProcessor)new CheckExclusiveAttributes((String[][])new String[][]{{"numberOfConcurrentTransactedReceivers"}, {NUMBER_OF_CONSUMERS_ATTRIBUTE}}));
        this.registerBeanDefinitionParser("custom-connector", (BeanDefinitionParser)new JmsConnectorDefinitionParser());
        this.registerBeanDefinitionParser("activemq-connector", (BeanDefinitionParser)new JmsConnectorDefinitionParser(ActiveMQJmsConnector.class));
        this.registerBeanDefinitionParser("activemq-xa-connector", (BeanDefinitionParser)new JmsConnectorDefinitionParser(ActiveMQXAJmsConnector.class));
        this.registerBeanDefinitionParser("mulemq-connector", (BeanDefinitionParser)new MuleMQConnectorDefinitionParser(MuleMQJmsConnector.class));
        this.registerBeanDefinitionParser("mulemq-xa-connector", (BeanDefinitionParser)new MuleMQConnectorDefinitionParser(MuleMQXAJmsConnector.class));
        this.registerBeanDefinitionParser("weblogic-connector", (BeanDefinitionParser)new JmsConnectorDefinitionParser(WeblogicJmsConnector.class));
        this.registerBeanDefinitionParser("websphere-connector", (BeanDefinitionParser)new JmsConnectorDefinitionParser(WebsphereJmsConnector.class));
        this.registerBeanDefinitionParser("transaction", (BeanDefinitionParser)new TransactionDefinitionParser(JmsTransactionFactory.class));
        this.registerBeanDefinitionParser("client-ack-transaction", (BeanDefinitionParser)new TransactionDefinitionParser(JmsClientAcknowledgeTransactionFactory.class));
        this.registerBeanDefinitionParser("jmsmessage-to-object-transformer", (BeanDefinitionParser)new MessageProcessorDefinitionParser(JMSMessageToObject.class));
        this.registerBeanDefinitionParser("object-to-jmsmessage-transformer", (BeanDefinitionParser)new MessageProcessorDefinitionParser(ObjectToJMSMessage.class));
        this.registerBeanDefinitionParser("property-filter", (BeanDefinitionParser)new FilterDefinitionParser(JmsPropertyFilter.class));
        this.registerBeanDefinitionParser("selector", (BeanDefinitionParser)new FilterDefinitionParser(JmsSelectorFilter.class));
        this.registerBeanDefinitionParser("default-jndi-name-resolver", (BeanDefinitionParser)new ChildDefinitionParser("jndiNameResolver", SimpleJndiNameResolver.class));
        this.registerBeanDefinitionParser("custom-jndi-name-resolver", (BeanDefinitionParser)new ChildDefinitionParser("jndiNameResolver"));
    }

    protected void registerJmsTransportEndpoints() {
        this.registerJmsEndpointDefinitionParser("endpoint", (MuleDefinitionParser)new TransportGlobalEndpointDefinitionParser("jms", false, TransportGlobalEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, JMS_ATTRIBUTES, (String[][])new String[0][]));
        this.registerJmsEndpointDefinitionParser("inbound-endpoint", (MuleDefinitionParser)new TransportEndpointDefinitionParser("jms", false, InboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, JMS_ATTRIBUTES, (String[][])new String[0][]));
        this.registerJmsEndpointDefinitionParser("outbound-endpoint", (MuleDefinitionParser)new TransportEndpointDefinitionParser("jms", false, OutboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, JMS_ATTRIBUTES, (String[][])new String[0][]));
    }

    protected void registerJmsEndpointDefinitionParser(String element, MuleDefinitionParser parser) {
        parser.addAlias(QUEUE, "path");
        parser.addAlias(TOPIC, "path");
        parser.addMapping(TOPIC, (ValueMap)new PrefixValueMap("topic:"));
        this.registerBeanDefinitionParser(element, (BeanDefinitionParser)parser);
    }
}

