/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    protected static Log staticLogger = LogFactory.getLog(AbstractMessageDispatcher.class);
    protected JdbcConnector connector;

    public JdbcMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JdbcConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        this.doSend(event);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        JdbcConnector jdbcConnector = (JdbcConnector)this.endpoint.getConnector();
        String statement = jdbcConnector.getStatement(this.endpoint);
        Object payload = event.getMessage().getPayload();
        SqlStatementStrategy strategy = jdbcConnector.getSqlStatementStrategyFactory().create(statement, payload);
        return strategy.executeStatement(jdbcConnector, this.endpoint, event, event.getTimeout());
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

