/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm;

import java.util.HashMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.bpm.ProcessConnector;
import org.mule.util.StringUtils;

public class ProcessMessageDispatcher
extends AbstractMessageDispatcher {
    private ProcessConnector connector;

    public ProcessMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (ProcessConnector)endpoint.getConnector();
    }

    public MuleMessage doSend(MuleEvent event) throws Exception {
        Object process = this.processAction(event);
        if (process != null) {
            DefaultMuleMessage msg = new DefaultMuleMessage(process);
            msg.setProperty("MULE_BPM_PROCESS_ID", this.connector.getBpms().getId(process));
            return msg;
        }
        throw new DispatchException(MessageFactory.createStaticMessage((String)"Synchronous process invocation must return the new process state."), event.getMessage(), event.getEndpoint());
    }

    public void doDispatch(MuleEvent event) throws Exception {
        this.processAction(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object processAction(MuleEvent event) throws Exception {
        Object payload;
        Object process = null;
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        if (event != null) {
            for (String propertyName : event.getMessage().getPropertyNames()) {
                processVariables.put(propertyName, event.getMessage().getProperty(propertyName));
            }
            payload = event.transformMessage();
            if (payload != null && !(payload instanceof NullPayload)) {
                processVariables.put("incoming", payload);
                String originatingEndpoint = event.getMessage().getStringProperty("MULE_ORIGINATING_ENDPOINT", null);
                if (StringUtils.isNotEmpty((String)originatingEndpoint)) {
                    processVariables.put("incomingSource", originatingEndpoint);
                }
            }
        }
        Object processType = event.getProperty("MULE_BPM_PROCESS_TYPE");
        processVariables.remove("MULE_BPM_PROCESS_TYPE");
        String processIdField = this.connector.getProcessIdField();
        if (StringUtils.isNotEmpty((String)processIdField)) {
            payload = event.getProperty(processIdField);
        }
        Object processId = event.getProperty("MULE_BPM_PROCESS_ID");
        processVariables.remove("MULE_BPM_PROCESS_ID");
        String action = event.getMessage().getStringProperty("MULE_BPM_ACTION", "advance");
        processVariables.remove("MULE_BPM_ACTION");
        Object transition = event.getMessage().getProperty("MULE_BPM_TRANSITION");
        processVariables.remove("MULE_BPM_TRANSITION");
        String temp = event.getEndpoint().getEndpointURI().getHost();
        if (StringUtils.isNotEmpty((String)temp)) {
            processType = temp;
        }
        if (StringUtils.isNotEmpty((String)(temp = event.getEndpoint().getEndpointURI().getPath()))) {
            if (temp.startsWith("/")) {
                temp = StringUtils.right((String)temp, (int)(temp.length() - 1));
            }
            if (temp.indexOf("/") != -1) {
                throw new IllegalArgumentException("Unexpected format in the path of the URL: " + temp);
            }
            processId = temp;
        }
        if (processId == null || action.equals("start")) {
            if (processType == null) throw new IllegalArgumentException("Process type is missing, cannot start a new process.");
            process = this.connector.getBpms().startProcess(processType, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("New process started, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("update")) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot update process.");
            process = this.connector.getBpms().updateProcess(processId, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process variables updated, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("abort")) {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot abort process.");
            this.connector.getBpms().abortProcess(processId);
            process = NullPayload.getInstance();
            this.logger.info((Object)("Process aborted, ID = " + processId));
            return process;
        } else {
            if (processId == null) throw new IllegalArgumentException("Process ID is missing, cannot advance process.");
            process = this.connector.getBpms().advanceProcess(processId, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process advanced, ID = " + this.connector.getBpms().getId(process) + ", new state = " + this.connector.getBpms().getState(process)));
        }
        return process;
    }
}

