/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.mule.tools.maven.plugin.Exclusion;
import org.mule.tools.maven.plugin.Inclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactFilter {
    private static final Set<String> MULE_GROUP_IDS = new HashSet<String>();
    private Set<Artifact> projectArtifacts;
    private List<Exclusion> excludes;
    private List<Inclusion> includes;
    private boolean excludeMuleArtifacts;

    public ArtifactFilter(MavenProject project, List<Inclusion> inclusions, List<Exclusion> exclusions, boolean excludeMuleDependencies) {
        this.projectArtifacts = Collections.unmodifiableSet(project.getArtifacts());
        this.includes = inclusions;
        this.excludes = exclusions;
        this.excludeMuleArtifacts = excludeMuleDependencies;
    }

    public Set<Artifact> getArtifactsToArchive() {
        Set<Artifact> filteredArtifacts = this.keepOnlyArtifactsWithCompileOrRuntimeScope();
        if (this.excludeMuleArtifacts) {
            filteredArtifacts = this.keepOnlyArtifactsWithoutMuleGroupId(filteredArtifacts);
        }
        filteredArtifacts = this.applyAllExcludes(filteredArtifacts);
        filteredArtifacts = this.applyAllIncludes(filteredArtifacts);
        return filteredArtifacts;
    }

    private Set<Artifact> keepOnlyArtifactsWithCompileOrRuntimeScope() {
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            String scope = artifact.getScope();
            if (!"compile".equals(scope) && !"runtime".equals(scope)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private Set<Artifact> keepOnlyArtifactsWithoutMuleGroupId(Set<Artifact> artifacts) {
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.isDependencyWithMuleGroupId(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private boolean isDependencyWithMuleGroupId(Artifact artifact) {
        List<String> dependencyTrail = this.getDependencyTrailWithoutProjectArtifact(artifact);
        for (String trailElement : dependencyTrail) {
            for (String groupId : MULE_GROUP_IDS) {
                if (!trailElement.startsWith(groupId)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getDependencyTrailWithoutProjectArtifact(Artifact artifact) {
        ArrayList<String> dependencyTrail = new ArrayList<String>(artifact.getDependencyTrail());
        dependencyTrail.remove(0);
        return dependencyTrail;
    }

    private Set<Artifact> applyAllExcludes(Set<Artifact> artifacts) {
        if (this.excludes != null) {
            for (Exclusion exclude : this.excludes) {
                artifacts = this.applyExclude(exclude, artifacts);
            }
        }
        return artifacts;
    }

    private Set<Artifact> applyExclude(Exclusion exclude, Set<Artifact> artifacts) {
        String filter = exclude.asFilter();
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.dependencyTrailContains(artifact, filter)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private boolean dependencyTrailContains(Artifact artifact, String filter) {
        List dependencyTrail = artifact.getDependencyTrail();
        for (Object trailElement : dependencyTrail) {
            if (!trailElement.toString().startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    private Set<Artifact> applyAllIncludes(Set<Artifact> filteredArtifacts) {
        if (this.includes != null) {
            for (Inclusion inc : this.includes) {
                this.applyInclude(inc, filteredArtifacts);
            }
        }
        return filteredArtifacts;
    }

    private void applyInclude(Inclusion inclusion, Set<Artifact> filteredArtifacts) {
        String filter = inclusion.asFilter() + ":";
        for (Artifact artifact : this.projectArtifacts) {
            if (!this.dependencyTrailContains(artifact, filter) || artifact.isOptional()) continue;
            filteredArtifacts.add(artifact);
        }
    }

    static {
        MULE_GROUP_IDS.add("org.mule");
        MULE_GROUP_IDS.add("com.mulesource.muleesb");
        MULE_GROUP_IDS.add("com.mulesoft.muleesb");
    }
}

