/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.functional.FlowAssert;

public class AssertionMessageProcessor
implements MessageProcessor,
FlowConstructAware,
Startable {
    private String expression;
    private String message = "?";
    private int count = 1;
    private int invocationCount = 0;
    private boolean needToMatchCount = false;
    private int timeout = 5000;
    private MuleEvent event;
    private CountDownLatch latch;
    private FlowConstruct flowConstruct;
    private ExpressionManager expressionManager;
    private boolean result = true;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void start() throws InitialisationException {
        this.expressionManager = this.flowConstruct.getMuleContext().getExpressionManager();
        this.expressionManager.validateExpression(this.expression);
        this.latch = new CountDownLatch(this.count);
        FlowAssert.addAssertion(this.flowConstruct.getName(), this);
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        this.event = event;
        this.result = this.result && this.expressionManager.evaluateBoolean(this.expression, event, false, true);
        this.latch.countDown();
        this.increaseCount();
        return event;
    }

    public void verify() throws InterruptedException {
        if (this.countFailOrNullEvent().booleanValue()) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. No message recieved or if count attribute was " + "set then it was no matched."));
        } else if (this.expressionFailed().booleanValue()) {
            Assert.fail((String)("Flow assertion '" + this.message + "' failed. Expression " + this.expression + " evaluated false."));
        }
    }

    public Boolean countFailOrNullEvent() throws InterruptedException {
        return !this.isProcessesCountCorrect() || this.event == null;
    }

    public Boolean expressionFailed() {
        return !this.result;
    }

    public void reset() {
        this.event = null;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCount(int count) {
        this.count = count;
        this.needToMatchCount = true;
    }

    private synchronized void increaseCount() {
        ++this.invocationCount;
    }

    private synchronized boolean isProcessesCountCorrect() throws InterruptedException {
        boolean countReached = this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
        if (this.needToMatchCount) {
            return this.count == this.invocationCount;
        }
        return countReached;
    }
}

