/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.lock.ServerLock;

public class ServerLockTestCase
extends AbstractMuleTestCase {
    public static final int THREAD_COUNT = 100;
    public static final int ITERATIONS_PER_THREAD = 100;
    private Latch threadStartLatch = new Latch();
    private String sharedKeyA = "A";
    private String sharedKeyB = "B";
    private ServerLock<String> serverLock = new ServerLock();
    private InMemoryObjectStore objectStore = new InMemoryObjectStore();

    @Test
    public void testHighConcurrency() throws Exception {
        ArrayList<IncrementKeyValueThread> threads = new ArrayList<IncrementKeyValueThread>(100);
        for (int i = 0; i < 100; ++i) {
            IncrementKeyValueThread incrementKeyValueThread = new IncrementKeyValueThread(this.sharedKeyA);
            threads.add(incrementKeyValueThread);
            incrementKeyValueThread.start();
            IncrementKeyValueThread incrementKeyValueThread2 = new IncrementKeyValueThread(this.sharedKeyB);
            threads.add(incrementKeyValueThread2);
            incrementKeyValueThread2.start();
        }
        this.threadStartLatch.release();
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertThat((Object)this.objectStore.retrieve((Serializable)((Object)this.sharedKeyA)), (Matcher)Is.is((Object)10000));
        Assert.assertThat((Object)this.objectStore.retrieve((Serializable)((Object)this.sharedKeyB)), (Matcher)Is.is((Object)10000));
    }

    public static class InMemoryObjectStore
    implements ObjectStore<Integer> {
        private Map<Serializable, Integer> store = new HashMap<Serializable, Integer>();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, Integer value) throws ObjectStoreException {
            if (this.store.containsKey(key)) {
                throw new ObjectAlreadyExistsException(CoreMessages.createStaticMessage((String)""));
            }
            this.store.put(key, value);
        }

        public Integer retrieve(Serializable key) throws ObjectStoreException {
            return this.store.get(key);
        }

        public Integer remove(Serializable key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public boolean isPersistent() {
            return false;
        }
    }

    public class IncrementKeyValueThread
    extends Thread {
        private String key;

        public IncrementKeyValueThread(String key) {
            super("Thread-" + key);
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerLockTestCase.this.threadStartLatch.await(5000L, TimeUnit.MILLISECONDS);
                for (int i = 0; i < 100 && !Thread.interrupted(); ++i) {
                    ServerLockTestCase.this.serverLock.lock((Object)this.key);
                    try {
                        Integer value;
                        if (ServerLockTestCase.this.objectStore.contains((Serializable)((Object)this.key))) {
                            value = ServerLockTestCase.this.objectStore.retrieve((Serializable)((Object)this.key));
                            ServerLockTestCase.this.objectStore.remove((Serializable)((Object)this.key));
                        } else {
                            value = 0;
                        }
                        ServerLockTestCase.this.objectStore.store((Serializable)((Object)this.key), value + 1);
                        continue;
                    }
                    finally {
                        ServerLockTestCase.this.serverLock.unlock((Object)this.key);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

