/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.OrangeInterface;
import org.mule.util.BeanUtils;

public class BeanUtilsTestCase
extends AbstractMuleTestCase {
    private Map<String, String> map;

    @Before
    public void createTestData() {
        this.map = new HashMap<String, String>();
        this.map.put("brand", "Juicy!");
        this.map.put("radius", "2.32");
        this.map.put("segments", "22");
        this.map.put("trombones", "3");
    }

    @Test
    public void testBeanPropertiesOnAProxy() throws Exception {
        OrangeInterface o = (OrangeInterface)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{OrangeInterface.class}, (InvocationHandler)new OrangeInvocationHandler(new Orange()));
        BeanUtils.populateWithoutFail((Object)o, this.map, (boolean)true);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"Juicy!", (Object)o.getBrand());
        Assert.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        Assert.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    @Test
    public void testBeanPropertiesWithoutFail() throws Exception {
        Orange o = new Orange();
        BeanUtils.populateWithoutFail((Object)o, this.map, (boolean)true);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"Juicy!", (Object)o.getBrand());
        Assert.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        Assert.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    @Test
    public void testBeanPropertiesWithFail() throws Exception {
        try {
            BeanUtils.populate((Object)new Orange(), this.map);
            Assert.fail((String)"Trombones is not a valid property");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((e.getMessage().indexOf("trombone") > -1 ? 1 : 0) != 0);
        }
    }

    private class OrangeInvocationHandler
    implements InvocationHandler {
        private Orange orange;

        public OrangeInvocationHandler(Orange orange) {
            this.orange = orange;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.orange, args);
        }
    }
}

