/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

public class ResponseMessageProcessorAdapterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testResponseAdaptorSingleMP() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new StringAppendTransformer("1"), new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("3")), new StringAppendTransformer("2")});
        Assert.assertEquals((Object)"0123", (Object)builder.build().process(ResponseMessageProcessorAdapterTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testResponseAdaptorSingleMPReturnsNull() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new StringAppendTransformer("1"), new ResponseMessageProcessorAdapter((MessageProcessor)new ReturnNullMP()), new StringAppendTransformer("2")});
        Assert.assertEquals((Object)"012", (Object)builder.build().process(ResponseMessageProcessorAdapterTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testResponseAdaptorNestedChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new StringAppendTransformer("1"), new ResponseMessageProcessorAdapter((MessageProcessor)new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new StringAppendTransformer("a"), new StringAppendTransformer("b")}).build()), new StringAppendTransformer("2")});
        Assert.assertEquals((Object)"012ab", (Object)builder.build().process(ResponseMessageProcessorAdapterTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testResponseAdaptorNestedChainReturnsNull() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new StringAppendTransformer("1"), new ResponseMessageProcessorAdapter((MessageProcessor)new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new StringAppendTransformer("a"), new StringAppendTransformer("b"), new ReturnNullMP()}).build()), new StringAppendTransformer("2")});
        Assert.assertEquals((Object)"012", (Object)builder.build().process(ResponseMessageProcessorAdapterTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    private static class ReturnNullMP
    implements MessageProcessor {
        private ReturnNullMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return null;
        }
    }
}

