/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.processor.IdempotentRedeliveryPolicy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.SerializationUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.lock.ServerLock;
import org.mule.util.lock.ServerLockFactory;

public class IdempotentRedeliveryPolicyTestCase
extends AbstractMuleTestCase {
    public static final String STRING_MESSAGE = "message";
    public static final int MAX_REDELIVERY_COUNT = 0;
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ObjectStoreManager mockObjectStoreManager = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockFailingMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockWaitingMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockDlqMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private Latch waitLatch = new Latch();
    private CountDownLatch waitingMessageProcessorExecutionLatch = new CountDownLatch(2);
    private final IdempotentRedeliveryPolicy irp = new IdempotentRedeliveryPolicy();
    @Rule
    public SystemProperty systemProperty = new SystemProperty("mule.encoding", "utf-8");

    @Before
    public void setUpTest() throws MuleException {
        Mockito.when((Object)this.mockFailingMessageProcessor.process((MuleEvent)Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{new RuntimeException("failing")});
        Mockito.when((Object)this.mockWaitingMessageProcessor.process(this.event)).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocationOnMock) throws Throwable {
                IdempotentRedeliveryPolicyTestCase.this.waitingMessageProcessorExecutionLatch.countDown();
                IdempotentRedeliveryPolicyTestCase.this.waitLatch.await(2000L, TimeUnit.MILLISECONDS);
                return IdempotentRedeliveryPolicyTestCase.this.mockFailingMessageProcessor.process((MuleEvent)invocationOnMock.getArguments()[0]);
            }
        });
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_muleLockFactory")).thenReturn((Object)new ServerLockFactory());
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_muleObjectStoreManager")).thenReturn((Object)this.mockObjectStoreManager);
        InMemoryObjectStore inMemoryObjectStore = new InMemoryObjectStore();
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)inMemoryObjectStore);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        this.irp.setMaxRedeliveryCount(0);
        this.irp.setUseSecureHash(true);
        this.irp.setFlowConstruct((FlowConstruct)Mockito.mock(FlowConstruct.class));
        this.irp.setMuleContext(this.mockMuleContext);
        this.irp.setListener(this.mockFailingMessageProcessor);
        this.irp.setMessageProcessor(this.mockDlqMessageProcessor);
    }

    @Test
    public void messageDigestFailure() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn(new Object());
        this.irp.initialise();
        MuleEvent process = this.irp.process(this.event);
        Assert.assertNull((Object)process);
    }

    @Test
    public void testMessageRedeliveryUsingMemory() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)STRING_MESSAGE);
        this.irp.initialise();
        this.processUntilFailure();
        ((MessageProcessor)Mockito.verify((Object)this.mockDlqMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)1))).process(this.event);
    }

    @Test
    public void testMessageRedeliveryUsingSerializationStore() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)STRING_MESSAGE);
        this.irp.initialise();
        this.processUntilFailure();
        ((MessageProcessor)Mockito.verify((Object)this.mockDlqMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)1))).process(this.event);
    }

    @Test
    public void testThreadSafeObjectStoreUsage() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)STRING_MESSAGE);
        this.irp.setListener(this.mockWaitingMessageProcessor);
        this.irp.initialise();
        ExecuteIrpThread firstIrpExecutionThread = new ExecuteIrpThread();
        firstIrpExecutionThread.start();
        ExecuteIrpThread threadCausingRedeliveryException = new ExecuteIrpThread();
        threadCausingRedeliveryException.start();
        this.waitingMessageProcessorExecutionLatch.await(5000L, TimeUnit.MILLISECONDS);
        this.waitLatch.release();
        firstIrpExecutionThread.join();
        threadCausingRedeliveryException.join();
        ((MessageProcessor)Mockito.verify((Object)this.mockDlqMessageProcessor, (VerificationMode)VerificationModeFactory.times((int)1))).process(this.event);
    }

    private void processUntilFailure() {
        for (int i = 0; i < 2; ++i) {
            try {
                this.irp.process(this.event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class InMemoryObjectStore
    implements ObjectStore<AtomicInteger> {
        private Map<Serializable, AtomicInteger> store = new HashMap<Serializable, AtomicInteger>();
        private ServerLock lockableObjectStore = new ServerLock();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, AtomicInteger value) throws ObjectStoreException {
            this.store.put(key, value);
        }

        public AtomicInteger retrieve(Serializable key) throws ObjectStoreException {
            return this.store.get(key);
        }

        public AtomicInteger remove(Serializable key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public boolean isPersistent() {
            return false;
        }
    }

    public static class SerializationObjectStore
    implements ObjectStore<AtomicInteger> {
        private Map<Serializable, Serializable> store = new HashMap<Serializable, Serializable>();
        private ServerLock lockableObjectStore = new ServerLock();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, AtomicInteger value) throws ObjectStoreException {
            this.store.put(key, (Serializable)SerializationUtils.serialize((Serializable)value));
        }

        public AtomicInteger retrieve(Serializable key) throws ObjectStoreException {
            Serializable serializable = this.store.get(key);
            return (AtomicInteger)SerializationUtils.deserialize((byte[])((byte[])serializable));
        }

        public AtomicInteger remove(Serializable key) throws ObjectStoreException {
            Serializable serializable = this.store.remove(key);
            return (AtomicInteger)SerializationUtils.deserialize((byte[])((byte[])serializable));
        }

        public boolean isPersistent() {
            return false;
        }
    }

    public class ExecuteIrpThread
    extends Thread {
        public Exception exception;

        @Override
        public void run() {
            try {
                IdempotentRedeliveryPolicyTestCase.this.irp.process(IdempotentRedeliveryPolicyTestCase.this.event);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

