/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.service.Service;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractServiceTestCase
extends AbstractMuleContextTestCase {
    protected abstract Service getService();

    @Test
    public void testStart() throws MuleException {
        try {
            this.getService().start();
            Assert.fail((String)"Exception expected: Cannot start an uninitialised service");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getService().initialise();
        this.getService().start();
        try {
            this.getService().initialise();
            Assert.fail((String)"Exception expected: Cannot initialise an already initialised service");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.getService().dispose();
    }

    @Test
    public void testPause() throws MuleException {
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        Assert.assertFalse((boolean)this.getService().isStopped());
        this.getService().initialise();
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        Assert.assertFalse((boolean)this.getService().isStopped());
        try {
            this.getService().resume();
            Assert.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().start();
        Assert.assertTrue((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        Assert.assertFalse((boolean)this.getService().isStopped());
        this.getService().pause();
        Assert.assertTrue((boolean)this.getService().isPaused());
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isStopped());
        try {
            this.getService().pause();
            Assert.fail((String)"cannot pause a service that is already paused");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.getService().isPaused());
        this.getService().dispose();
    }

    @Test
    public void testResume() throws MuleException {
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().initialise();
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().resume();
            Assert.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().start();
        Assert.assertTrue((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().resume();
            Assert.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().pause();
        Assert.assertTrue((boolean)this.getService().isPaused());
        this.getService().resume();
        Assert.assertFalse((boolean)this.getService().isPaused());
        Assert.assertTrue((boolean)this.getService().isStarted());
        try {
            this.getService().resume();
            Assert.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().dispose();
    }

    @Test
    public void testStop() throws MuleException {
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().stop();
            Assert.fail((String)"Exception expected: Cannot stop an uninitialised service");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.getService().resume();
            Assert.fail((String)"Exception expected: Cannot resume an uninitialised service");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.getService().initialise();
        Assert.assertFalse((boolean)this.getService().isStarted());
        this.getService().stop();
        Assert.assertFalse((boolean)this.getService().isStarted());
        this.getService().start();
        Assert.assertTrue((boolean)this.getService().isStarted());
        this.getService().stop();
        Assert.assertFalse((boolean)this.getService().isStarted());
        try {
            this.getService().stop();
            Assert.fail((String)"Exception expected: Cannot stop a service that is not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getService().isStarted());
        this.getService().dispose();
    }

    @Test
    public void testDispose() throws MuleException {
        Assert.assertFalse((boolean)this.getService().isStarted());
        Assert.assertFalse((boolean)this.getService().isPaused());
        this.getService().dispose();
        try {
            this.getService().dispose();
            Assert.fail((String)"Exception expected: Cannot dispose a service that is already disposed");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.getService().initialise();
            Assert.fail((String)"Exception expected: Cannot invoke initialise (or any lifecycle) on an object once it is disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

