/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct.processor;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.MessageSource;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.Flow;
import org.mule.context.notification.AsyncMessageNotification;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.management.stats.AllStatistics;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PipelineMessageNotificationTestCase
extends AbstractMuleTestCase {
    private MuleEvent event;
    private MuleContext muleContext;
    private ServerNotificationManager notificationManager;
    private TestPipeline pipeline;
    private final String pipelineName = "testPipeline";

    @Before
    public void createMocks() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.muleContext.getStatistics()).thenReturn((Object)new AllStatistics());
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)new MuleRegistryHelper(new DefaultRegistryBroker(this.muleContext), this.muleContext));
        Mockito.when((Object)this.muleContext.getDefaultThreadingProfile()).thenReturn((Object)new ChainedThreadingProfile());
        this.notificationManager = (ServerNotificationManager)Mockito.mock(ServerNotificationManager.class);
        Mockito.when((Object)this.muleContext.getNotificationManager()).thenReturn((Object)this.notificationManager);
        this.pipeline = new TestPipeline("testPipeline", this.muleContext);
    }

    @Test
    public void requestResponse() throws MuleException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource(source);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        source.trigger(this.event);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWay() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource(source);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.pipeline);
        source.trigger(this.event);
        this.pipeline.latch.await(5000L, TimeUnit.MILLISECONDS);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource(source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<1> processors = new ArrayList<1>();
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new RuntimeException("error");
            }
        });
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)2))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void requestResponseResponseException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource(source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<2> processors = new ArrayList<2>();
        processors.add(new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                this.processNext(event);
                throw new RuntimeException("error");
            }
        });
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1802, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)3))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWayRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        this.pipeline.setMessageSource(source);
        this.pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<3> processors = new ArrayList<3>();
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new RuntimeException("error");
            }
        });
        this.pipeline.setMessageProcessors(processors);
        this.pipeline.initialise();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.pipeline);
        try {
            source.trigger(this.event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, true, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)2))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    @Test
    public void oneWayAsyncRequestException() throws MuleException, InterruptedException {
        TriggerableMessageSource source = new TriggerableMessageSource();
        Flow pipeline = new Flow("test", this.muleContext);
        pipeline.setProcessingStrategy((ProcessingStrategy)new AsynchronousProcessingStrategy());
        final CountDownLatch latch = new CountDownLatch(1);
        pipeline.setMessageSource((MessageSource)source);
        pipeline.setExceptionListener((MessagingExceptionHandler)new DefaultMessagingExceptionStrategy());
        ArrayList<4> processors = new ArrayList<4>();
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                latch.countDown();
                throw new RuntimeException("error");
            }
        });
        pipeline.setMessageProcessors(processors);
        pipeline.initialise();
        pipeline.start();
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"request", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)pipeline);
        source.trigger(this.event);
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Thread.sleep(2000L);
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1801, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1901, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1804, false, this.event)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)1))).fireNotification((ServerNotification)Matchers.argThat((Matcher)new PipelineMessageNotificiationArgumentMatcher(1902, false, null)));
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager, (VerificationMode)Mockito.times((int)4))).fireNotification((ServerNotification)Matchers.any(PipelineMessageNotification.class));
    }

    private class PipelineMessageNotificiationArgumentMatcher
    extends ArgumentMatcher<PipelineMessageNotification> {
        private int expectedAction;
        private boolean exceptionExpected;
        private MuleEvent event;

        public PipelineMessageNotificiationArgumentMatcher(int expectedAction, boolean exceptionExpected, MuleEvent event) {
            this.expectedAction = expectedAction;
            this.exceptionExpected = exceptionExpected;
            this.event = event;
        }

        public boolean matches(Object argument) {
            ServerNotification notification = (ServerNotification)argument;
            if (this.exceptionExpected) {
                MessagingException exception = null;
                if (notification instanceof PipelineMessageNotification) {
                    exception = ((PipelineMessageNotification)notification).getException();
                } else if (notification instanceof AsyncMessageNotification) {
                    exception = ((AsyncMessageNotification)notification).getException();
                }
                return this.expectedAction == notification.getAction() && exception != null && notification.getSource() != null && (this.event == null || this.event == notification.getSource());
            }
            return this.expectedAction == notification.getAction() && notification.getSource() != null && (this.event == null || this.event == notification.getSource());
        }
    }

    private class TestPipeline
    extends AbstractPipeline {
        CountDownLatch latch;

        public TestPipeline(String name, MuleContext muleContext) {
            super(name, muleContext);
            this.latch = new CountDownLatch(2);
        }

        protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            builder.chain(new MessageProcessor[]{new AbstractInterceptingMessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    event.getMessage().setPayload((Object)"request-processed");
                    MuleEvent result = this.processNext(event);
                    event.getMessage().setPayload((Object)"response-processed");
                    TestPipeline.this.latch.countDown();
                    return result;
                }
            }});
            super.configureMessageProcessors(builder);
        }

        protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            super.configurePostProcessors(builder);
            builder.chain(new MessageProcessor[]{new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    TestPipeline.this.latch.countDown();
                    return event;
                }
            }});
        }

        public String getConstructType() {
            return "test";
        }
    }
}

