/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.mule.api.store.ObjectStore;
import org.mule.util.store.DefaultObjectStoreFactory;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.mule.util.store.SimpleMemoryObjectStore;

public class DefaultObjectStoreFactoryBean {
    private static DefaultObjectStoreFactory delegate;

    private DefaultObjectStoreFactoryBean() {
    }

    public static void setDelegate(DefaultObjectStoreFactory theDelegate) {
        delegate = theDelegate;
    }

    public static ObjectStore<Serializable> createDefaultInMemoryObjectStore() {
        if (delegate != null) {
            return delegate.createDefaultInMemoryObjectStore();
        }
        return new SimpleMemoryObjectStore<Serializable>();
    }

    public static ObjectStore<Serializable> createDefaultPersistentObjectStore() {
        if (delegate != null) {
            return delegate.createDefaultPersistentObjectStore();
        }
        return new QueuePersistenceObjectStore<Serializable>();
    }
}

