/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.expression.ExpressionConfig;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.CollectionSplitter;
import org.mule.routing.ExpressionSplitter;
import org.mule.routing.MapSplitter;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.routing.outbound.CollectionMessageSequence;

public class ForeachMessageProcessor
extends AbstractMessageProcessorOwner
implements Initialisable,
InterceptingMessageProcessor {
    public static final String ROOT_MESSAGE_PROPERTY = "rootMessage";
    public static final String COUNTER_PROPERTY = "counter";
    protected Log logger = LogFactory.getLog(this.getClass());
    private List<MessageProcessor> messageProcessors;
    private MessageProcessor ownedMessageProcessor;
    private AbstractMessageSequenceSplitter splitter;
    private MessageProcessor next;
    private String expression;
    private int groupSize;
    private String rootMessageVariableName;
    private String counterVariableName;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        String parentMessageProp = this.rootMessageVariableName != null ? this.rootMessageVariableName : ROOT_MESSAGE_PROPERTY;
        event.getMessage().setInvocationProperty(parentMessageProp, event.getMessage());
        this.ownedMessageProcessor.process(event);
        return this.processNext(event);
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        return this.next.process(event);
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.next = listener;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.expression != null) {
            ExpressionConfig config = new ExpressionConfig();
            config.setExpression(this.expression);
            this.splitter = new ExpressionSplitter(config);
        } else {
            this.splitter = new CollectionMapSplitter();
        }
        this.splitter.setGroupSize(this.groupSize);
        this.splitter.setCounterVariableName(this.counterVariableName);
        this.splitter.setMuleContext(this.muleContext);
        this.messageProcessors.add(0, this.splitter);
        try {
            this.ownedMessageProcessor = new DefaultMessageProcessorChainBuilder().chain(this.messageProcessors).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.initialise();
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    private static class CollectionMapSplitter
    extends CollectionSplitter {
        private CollectionMapSplitter() {
        }

        @Override
        protected MessageSequence<?> splitMessageIntoSequence(MuleEvent event) {
            Object payload = event.getMessage().getPayload();
            if (payload instanceof Map) {
                LinkedList<DefaultMuleMessage> list = new LinkedList<DefaultMuleMessage>();
                Set set = ((Map)payload).entrySet();
                for (Map.Entry entry : set) {
                    DefaultMuleMessage splitMessage = new DefaultMuleMessage(entry.getValue(), this.muleContext);
                    splitMessage.setInvocationProperty(MapSplitter.MAP_ENTRY_KEY, entry.getKey());
                    list.add(splitMessage);
                }
                return new CollectionMessageSequence(list);
            }
            return super.splitMessageIntoSequence(event);
        }
    }
}

