/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.util.CollectionUtils;

public class DefaultRouterResultsHandler
implements RouterResultsHandler {
    @Override
    public MuleEvent aggregateResults(List<MuleEvent> results, MuleEvent previous, MuleContext muleContext) {
        if (results == null) {
            return null;
        }
        if (results.size() == 1) {
            MuleEvent event = results.get(0);
            if (event != null && event.getMessage() != null) {
                return event;
            }
            return null;
        }
        List nonNullResults = (List)CollectionUtils.select(results, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && ((MuleEvent)object).getMessage() != null;
            }
        });
        if (nonNullResults.size() == 0) {
            return null;
        }
        if (nonNullResults.size() == 1) {
            return (MuleEvent)nonNullResults.get(0);
        }
        return this.createMessageCollection(nonNullResults, previous, muleContext);
    }

    private MuleEvent createMessageCollection(List<MuleEvent> nonNullResults, MuleEvent previous, MuleContext muleContext) {
        DefaultMessageCollection coll = new DefaultMessageCollection(muleContext);
        for (MuleEvent event : nonNullResults) {
            coll.addMessage(event.getMessage());
        }
        coll.propagateRootId(previous.getMessage());
        DefaultMuleEvent resultEvent = new DefaultMuleEvent((MuleMessage)coll, previous, previous.getSession());
        for (String name : previous.getFlowVariableNames()) {
            resultEvent.setFlowVariable(name, previous.getFlowVariable(name));
        }
        return OptimizedRequestContext.unsafeSetEvent(resultEvent);
    }
}

