/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.util.ObjectUtils;

public abstract class AbstractInterceptingMessageProcessorBase
implements MessageProcessor,
MuleContextAware,
AnnotatedObject {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected ServerNotificationHandler notificationHandler;
    protected MuleContext muleContext;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();
    protected MessageProcessor next;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.notificationHandler = this.muleContext.getNotificationManager();
        if (this.next instanceof DefaultMessageProcessorChain) {
            ((DefaultMessageProcessorChain)this.next).setMuleContext(context);
        }
    }

    public final MessageProcessor getListener() {
        return this.next;
    }

    public void setListener(MessageProcessor next) {
        this.next = next;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        MuleEvent result;
        boolean fireNotification;
        if (this.next == null) {
            return event;
        }
        if (event == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.trace((Object)("MuleEvent is null.  Next MessageProcessor '" + this.next.getClass().getName() + "' will not be invoked."));
            }
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        boolean bl = fireNotification = !(this.next instanceof MessageProcessorChain);
        if (fireNotification) {
            this.fireNotification(event.getFlowConstruct(), event, this.next, 1601);
        }
        try {
            result = this.next.process(event);
        }
        catch (MuleException e) {
            event.getSession().setValid(false);
            throw e;
        }
        if (fireNotification) {
            this.fireNotification(event.getFlowConstruct(), result, this.next, 1602);
        }
        return result;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    protected void fireNotification(FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, int action) {
        if (this.notificationHandler != null && this.notificationHandler.isNotificationEnabled(MessageProcessorNotification.class)) {
            this.notificationHandler.fireNotification(new MessageProcessorNotification(flowConstruct, event, processor, action));
        }
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

