/*
 * Decompiled with CFR 0.152.
 */
package org.mule.process;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.process.ProcessingCallback;
import org.mule.process.ProcessingInterceptor;

class HandleExceptionInterceptor
implements ProcessingInterceptor<MuleEvent> {
    private final ProcessingInterceptor<MuleEvent> next;
    private MessagingExceptionHandler messagingExceptionHandler;

    public HandleExceptionInterceptor(ProcessingInterceptor<MuleEvent> next, MessagingExceptionHandler messagingExceptionHandler) {
        this.next = next;
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    @Override
    public MuleEvent execute(ProcessingCallback<MuleEvent> callback) throws Exception {
        try {
            return this.next.execute(callback);
        }
        catch (MessagingException e) {
            MuleEvent result = this.messagingExceptionHandler != null ? this.messagingExceptionHandler.handleException(e, e.getEvent()) : e.getEvent().getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
            e.setProcessedEvent(result);
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

