/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.exception.AbstractExceptionListener;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;

public abstract class TemplateMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private MessageProcessor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String expression;

    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event) {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        this.fireNotification(exception);
        this.logException(exception);
        this.processStatistics(event);
        event.getMessage().setExceptionPayload(new DefaultExceptionPayload(exception));
        event = this.beforeRouting(exception, event);
        event = this.route(event, exception);
        this.processOutboundRouterStatistics(flowConstruct);
        event = this.afterRouting(exception, event);
        if (event != null) {
            this.processReplyTo(event, exception);
            this.closeStream(event.getMessage());
            this.nullifyExceptionPayloadIfRequired(event);
        }
        return event;
    }

    protected void processReplyTo(MuleEvent event, Exception e) {
        try {
            this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
        }
    }

    protected void nullifyExceptionPayloadIfRequired(MuleEvent event) {
    }

    private void processStatistics(MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected MuleEvent route(MuleEvent event, Exception t) {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
                MuleEvent result = this.configuredMessageProcessors.process(event);
                return result;
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        try {
            this.configuredMessageProcessors = defaultMessageProcessorChainBuilder.chain(this.getMessageProcessors()).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean accept(MuleEvent event) {
        return this.acceptsAll() || this.muleContext.getExpressionManager().evaluateBoolean(this.expression, event.getMessage());
    }

    @Override
    public boolean acceptsAll() {
        return this.expression == null;
    }

    protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
        return event;
    }

    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        return event;
    }
}

