/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Stoppable;
import org.mule.exception.AbstractExceptionListener;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.NullPayload;

public abstract class AbstractMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandler {
    private boolean stopMessageProcessing;

    public AbstractMessagingExceptionStrategy() {
    }

    public AbstractMessagingExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    @Override
    public MuleEvent handleException(Exception ex, MuleEvent event) {
        this.fireNotification(ex);
        this.logException(ex);
        this.doHandleException(ex, event);
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(exceptionPayload);
        }
        event.getMessage().setPayload(NullPayload.getInstance());
        event.getMessage().setExceptionPayload(exceptionPayload);
        return event;
    }

    protected void doHandleException(Exception ex, MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
        this.defaultHandler(ex);
        if (this.isRollback(ex)) {
            this.logger.debug((Object)"Rolling back transaction");
            this.rollback(ex);
            this.logger.debug((Object)"Routing exception message");
            this.routeException(event, null, ex);
        } else {
            this.logger.debug((Object)"Routing exception message");
            this.routeException(event, null, ex);
        }
        this.closeStream(event.getMessage());
        if (this.stopMessageProcessing) {
            this.stopFlow(event.getFlowConstruct());
        }
    }

    protected void stopFlow(FlowConstruct flow) {
        if (flow instanceof Stoppable) {
            this.logger.info((Object)("Stopping flow '" + flow.getName() + "' due to exception"));
            try {
                ((Lifecycle)((Object)flow)).stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)("Unable to stop flow '" + flow.getName() + "'"), (Throwable)e);
            }
        } else {
            this.logger.warn((Object)"Flow is not stoppable");
        }
    }

    public boolean isStopMessageProcessing() {
        return this.stopMessageProcessing;
    }

    public void setStopMessageProcessing(boolean stopMessageProcessing) {
        this.stopMessageProcessing = stopMessageProcessing;
    }

    protected void defaultHandler(Throwable t) {
    }
}

