/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.processor.AbstractRedeliveryPolicy;

public class DynamicOutboundEndpoint
implements OutboundEndpoint {
    public static final String DYNAMIC_URI_PLACEHOLDER = "dynamic://endpoint";
    protected final transient Log logger = LogFactory.getLog(DynamicOutboundEndpoint.class);
    private static final long serialVersionUID = 8861985949279708638L;
    protected String uriTemplate;
    private final EndpointBuilder builder;
    private final OutboundEndpoint prototypeEndpoint;

    public DynamicOutboundEndpoint(EndpointBuilder builder, String uriTemplate) throws MalformedEndpointException {
        this.validateUriTemplate(uriTemplate);
        this.builder = builder;
        this.uriTemplate = uriTemplate;
        try {
            this.prototypeEndpoint = builder.buildOutboundEndpoint();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void validateUriTemplate(String uri) throws MalformedEndpointException {
        if (uri.indexOf(":") > uri.indexOf("#[")) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointsMustSpecifyAScheme(), uri);
        }
    }

    protected EndpointURI getEndpointURIForMessage(MuleEvent event) throws DispatchException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + this.uriTemplate));
        }
        String newUriString = this.uriTemplate;
        try {
            newUriString = this.parseURIString(newUriString, event.getMessage());
        }
        catch (ExpressionRuntimeException e) {
            throw new DispatchException(event, this, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + newUriString));
        }
        try {
            MuleEndpointURI resultUri = new MuleEndpointURI(newUriString, this.getMuleContext());
            resultUri.initialise();
            return resultUri;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.templateCausedMalformedEndpoint(this.uriTemplate, newUriString), event, this, e);
        }
    }

    protected String parseURIString(String uri, MuleMessage message) {
        return this.getMuleContext().getExpressionManager().parse(uri, message, true);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        EndpointURI endpointURIForMessage = this.getEndpointURIForMessage(event);
        OutboundEndpoint outboundEndpoint = this.createStaticEndpoint(endpointURIForMessage);
        event = new DefaultMuleEvent(event.getMessage(), endpointURIForMessage.getUri(), event.getMessageSourceName(), event.getExchangePattern(), event.getFlowConstruct(), event.getSession(), event.getTimeout(), event.getCredentials(), (ResponseOutputStream)event.getOutputStream(), event.getEncoding(), event.isTransacted(), event.isSynchronous(), event.getReplyToDestination(), event.getReplyToHandler());
        return outboundEndpoint.process(event);
    }

    private synchronized OutboundEndpoint createStaticEndpoint(EndpointURI uri) throws DispatchException, EndpointException, InitialisationException {
        this.builder.setURIBuilder(new URIBuilder(uri));
        return this.builder.buildOutboundEndpoint();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Connector getConnector() {
        throw new UnsupportedOperationException("No connector available");
    }

    @Override
    public EndpointURI getEndpointURI() {
        return null;
    }

    @Override
    public AbstractRedeliveryPolicy getRedeliveryPolicy() {
        return this.prototypeEndpoint.getRedeliveryPolicy();
    }

    @Override
    public String getAddress() {
        return this.uriTemplate;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.prototypeEndpoint.getRetryPolicyTemplate();
    }

    @Override
    public String getEncoding() {
        return this.prototypeEndpoint.getEncoding();
    }

    @Override
    public String getMimeType() {
        return this.prototypeEndpoint.getMimeType();
    }

    @Override
    public Filter getFilter() {
        return this.prototypeEndpoint.getFilter();
    }

    @Override
    public String getInitialState() {
        return this.prototypeEndpoint.getInitialState();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.prototypeEndpoint.getMuleContext();
    }

    @Override
    public String getName() {
        return this.prototypeEndpoint.getName();
    }

    @Override
    public Map getProperties() {
        return this.prototypeEndpoint.getProperties();
    }

    @Override
    public Object getProperty(Object key) {
        return this.prototypeEndpoint.getProperty(key);
    }

    @Override
    public String getProtocol() {
        return this.prototypeEndpoint.getProtocol();
    }

    @Override
    public int getResponseTimeout() {
        return this.prototypeEndpoint.getResponseTimeout();
    }

    @Override
    public List<Transformer> getResponseTransformers() {
        return this.prototypeEndpoint.getResponseTransformers();
    }

    @Override
    public EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.prototypeEndpoint.getMessageProcessorsFactory();
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.prototypeEndpoint.getMessageProcessors();
    }

    @Override
    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.prototypeEndpoint.getResponseMessageProcessors();
    }

    @Override
    public EndpointSecurityFilter getSecurityFilter() {
        return this.prototypeEndpoint.getSecurityFilter();
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.prototypeEndpoint.getTransactionConfig();
    }

    @Override
    public List<Transformer> getTransformers() {
        return this.prototypeEndpoint.getTransformers();
    }

    @Override
    public boolean isDeleteUnacceptedMessages() {
        return this.prototypeEndpoint.isDeleteUnacceptedMessages();
    }

    @Override
    public boolean isReadOnly() {
        return this.prototypeEndpoint.isReadOnly();
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.prototypeEndpoint.getExchangePattern();
    }

    @Override
    public List<String> getResponseProperties() {
        return this.prototypeEndpoint.getResponseProperties();
    }

    @Override
    public String getEndpointBuilderName() {
        return this.prototypeEndpoint.getEndpointBuilderName();
    }

    @Override
    public boolean isProtocolSupported(String protocol) {
        return this.prototypeEndpoint.isProtocolSupported(protocol);
    }

    @Override
    public boolean isDisableTransportTransformer() {
        return this.prototypeEndpoint.isDisableTransportTransformer();
    }
}

