/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.context.notification.ServerNotificationListener;

public class OptimisedNotificationHandler
implements ServerNotificationHandler {
    private ServerNotificationHandler delegate;
    private Class<? extends ServerNotification> type;
    private boolean dynamic = false;
    private boolean enabled = false;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class<? extends ServerNotification> type) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
        this.enabled = delegate.isNotificationEnabled(type);
    }

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isListenerRegistered(ServerNotificationListener listener) {
        return this.delegate.isListenerRegistered(listener);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends ServerNotification> notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }
}

