/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.StringUtils;

public class LoggerMessageProcessor
implements MessageProcessor,
Initialisable,
MuleContextAware,
AnnotatedObject {
    protected transient Log logger;
    protected String message;
    protected String category;
    protected String level = "DEBUG";
    protected MuleContext muleContext;
    protected ExpressionManager expressionManager;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    @Override
    public void initialise() throws InitialisationException {
        this.initLogger();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void initLogger() {
        this.logger = this.category != null ? LogFactory.getLog((String)this.category) : LogFactory.getLog(LoggerMessageProcessor.class);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        this.log(event);
        return event;
    }

    protected void log(MuleEvent event) {
        if (event == null) {
            this.logWithLevel(null);
        } else if (StringUtils.isEmpty((String)this.message)) {
            this.logWithLevel(event.getMessage());
        } else {
            this.logWithLevel(this.expressionManager.parse(this.message, event.getMessage()));
        }
    }

    protected void logWithLevel(Object object) {
        if ("ERROR".equals(this.level)) {
            this.logger.error(object);
        } else if ("WARN".equals(this.level)) {
            this.logger.warn(object);
        } else if ("INFO".equals(this.level)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(object);
            }
        } else if ("DEBUG".equals(this.level)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(object);
            }
        } else if ("TRACE".equals(this.level) && this.logger.isTraceEnabled()) {
            this.logger.trace(object);
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(String level) {
        this.level = level.toUpperCase();
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

