/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.TemplateParser;

@SmallTest
public class TemplateParserTestCase
extends AbstractMuleTestCase {
    @Test
    public void squareBracesParserDefaultConfiguration() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Assert.assertNotNull((Object)tp.getStyle());
        Assert.assertEquals((Object)"[", (Object)tp.getStyle().getPrefix());
        Assert.assertEquals((Object)"]", (Object)tp.getStyle().getSuffix());
    }

    @Test
    public void squareBracesParserShouldReplaceKnownTokens() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Map<String, String> map = Collections.singletonMap("fromAddress", "ross.mason@symphonysoft.com");
        String template = "smtp://[fromAddress]";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"smtp://ross.mason@symphonysoft.com", (Object)result);
    }

    @Test
    public void squareBracesParserShouldNotReplaceUnknownTokens() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Map map = Collections.emptyMap();
        String template = "smtp://[toAddress]";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"smtp://[toAddress]", (Object)result);
    }

    @Test
    public void squareBracesParserShouldValidateExpressionDelimiters() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Assert.assertTrue((boolean)tp.isValid("[][]"));
        Assert.assertTrue((boolean)tp.isValid("[[]]"));
        Assert.assertFalse((boolean)tp.isValid("[[][]"));
    }

    @Test
    public void antParserDefaultConfiguration() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Assert.assertNotNull((Object)tp.getStyle());
        Assert.assertEquals((Object)"${", (Object)tp.getStyle().getPrefix());
        Assert.assertEquals((Object)"}", (Object)tp.getStyle().getSuffix());
    }

    @Test
    public void antParserShouldValidateExpressionDelimiters() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Assert.assertTrue((boolean)tp.isValid("${}"));
        Assert.assertTrue((boolean)tp.isValid("${}${}"));
        Assert.assertFalse((boolean)tp.isValid("${}&{}"));
        Assert.assertFalse((boolean)tp.isValid("{}${}"));
        Assert.assertTrue((boolean)tp.isValid("${$}${}"));
        Assert.assertFalse((boolean)tp.isValid("${${}}${}"));
        Assert.assertFalse((boolean)tp.isValid("$ {}"));
    }

    @Test
    public void antParserShouldReplaceKnownTokens() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Map<String, Object> map = this.buildMap();
        String template = "Some String with ${prop1} and ${prop2} in it";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", (Object)result);
    }

    @Test
    public void antParserShouldNotReplaceUnknownTokens() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Map map = Collections.emptyMap();
        String template = "Some String with ${prop1} in it";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"Some String with ${prop1} in it", (Object)result);
    }

    @Test
    public void antParserShouldHandleWhitespaceAndBackslashesCorrectly() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        String dir = "C:\\Documents and Settings\\";
        Map<String, String> map = Collections.singletonMap("dir", dir);
        String template = "start${dir}end";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"startC:\\Documents and Settings\\end", (Object)result);
    }

    @Test
    public void antParserWithListInputShouldReplaceKnownTokens() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Map<String, Object> map = this.buildMap();
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("Some String with ${prop1} and ${prop2} in it");
        templates.add("Some String with ${prop1} in it");
        List result = tp.parse(map, templates);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", result.get(0));
        Assert.assertEquals((Object)"Some String with value1 in it", result.get(1));
    }

    @Test
    public void antParserWithNullListInputShouldNotReplaceTokens() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Map<String, Object> map = this.buildMap();
        List result = tp.parse(map, (List)null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void antParserWithSimilarTokensShouldNotBeConfused() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Map<String, Object> map = this.buildMap();
        map.put("prop1-2", "value2");
        String template = "Some String with ${prop1} and ${prop1-2} in it";
        String result = tp.parse(map, template);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", (Object)result);
    }

    @Test
    public void antParserWithOptionalTokenShouldReplaceKnownTokens() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1?", "value1");
        props.put("prop1-2", "value2");
        String template = "Some String with ${prop1?} and ${prop1-2} in it";
        String result = tp.parse(props, template);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", (Object)result);
    }

    @Test
    public void muleParserDefaultConfiguration() {
        TemplateParser tp = TemplateParser.createMuleStyleParser();
        Assert.assertNotNull((Object)tp.getStyle());
        Assert.assertEquals((Object)"#[", (Object)tp.getStyle().getPrefix());
        Assert.assertEquals((Object)"]", (Object)tp.getStyle().getSuffix());
    }

    @Test
    public void muleParserShouldValidateExpressionDelimiters() {
        TemplateParser tp = TemplateParser.createMuleStyleParser();
        Assert.assertTrue((boolean)tp.isValid("#[]"));
        Assert.assertTrue((boolean)tp.isValid("#[]   #[]"));
        Assert.assertFalse((boolean)tp.isValid("#[]&[]"));
        Assert.assertFalse((boolean)tp.isValid("[]$[]#"));
        Assert.assertTrue((boolean)tp.isValid("#[#]#[]"));
        Assert.assertFalse((boolean)tp.isValid("#[#[]]#[]"));
        Assert.assertFalse((boolean)tp.isValid("# []"));
        Assert.assertTrue((boolean)tp.isValid("#[foo:blah[4] = 'foo']"));
        Assert.assertTrue((boolean)tp.isValid("#[foo:blah[4] = '#foo']"));
        Assert.assertFalse((boolean)tp.isValid("#[foo:blah4] = '#foo']"));
        Assert.assertFalse((boolean)tp.isValid("#[foo:blah = '#[foo]']"));
    }

    private Map<String, Object> buildMap() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        return props;
    }
}

