/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConnectorTestCase
extends AbstractMuleContextTestCase {
    protected String connectorName;
    protected String encoding;

    @Override
    protected void doSetUp() throws Exception {
        Connector connector = this.createConnector();
        if (connector.getName() == null) {
            connector.setName("test");
        }
        this.connectorName = connector.getName();
        muleContext.getRegistry().registerConnector(connector);
        this.encoding = muleContext.getConfiguration().getDefaultEncoding();
    }

    @Override
    protected void doTearDown() throws Exception {
        Connector connector = this.getConnector();
        if (connector != null && connector.isDisposed()) {
            Assert.fail((String)("Connector has been disposed prematurely - lifecycle problem? Instance: " + connector));
        }
    }

    protected Connector getConnector() {
        return muleContext == null ? null : muleContext.getRegistry().lookupConnector(this.connectorName);
    }

    protected Connector getConnectorAndAssert() {
        Connector connector = this.getConnector();
        Assert.assertNotNull((Object)connector);
        return connector;
    }

    @Test
    public void testConnectorExceptionHandling() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        Mock ehandlerMock = new Mock(SystemExceptionHandler.class, "exceptionHandler");
        ehandlerMock.expect("handleException", (Object)C.isA(Exception.class));
        Assert.assertNotNull((Object)muleContext.getExceptionListener());
        muleContext.setExceptionListener((SystemExceptionHandler)ehandlerMock.proxy());
        muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
        if (connector instanceof AbstractConnector) {
            ehandlerMock.expect("handleException", (Object)C.isA(Exception.class));
            muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
        }
        ehandlerMock.verify();
        muleContext.setExceptionListener(null);
        try {
            muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
            Assert.fail((String)"Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectorLifecycle() throws Exception {
        Connector localConnector = this.createConnector();
        localConnector.setName(this.connectorName + "-temp");
        localConnector.initialise();
        localConnector.start();
        Assert.assertNotNull((Object)localConnector);
        Assert.assertTrue((boolean)localConnector.isStarted());
        Assert.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.stop();
        Assert.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        Assert.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.dispose();
        Assert.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)localConnector.isDisposed());
        try {
            localConnector.start();
            Assert.fail((String)"Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConnectorListenerSupport() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        Service service = AbstractConnectorTestCase.getTestService("anApple", Apple.class);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        try {
            connector.registerListener(null, null, (FlowConstruct)service);
            Assert.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(endpoint, null, (FlowConstruct)service);
            Assert.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(null, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
            Assert.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        connector.unregisterListener(endpoint, (FlowConstruct)service);
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            Assert.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            Assert.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            Assert.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.unregisterListener(endpoint, (FlowConstruct)service);
        muleContext.getRegistry().unregisterService(service.getName());
    }

    @Test
    public void testConnectorBeanProps() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        try {
            connector.setName(null);
            Assert.fail((String)"Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        connector.setName("Test");
        Assert.assertEquals((Object)"Test", (Object)connector.getName());
        Assert.assertNotNull((String)"Protocol must be set as a constant", (Object)connector.getProtocol());
    }

    @Test
    public void testConnectorMuleMessageFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MuleMessageFactory factory = connector.createMuleMessageFactory();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testConnectorMessageDispatcherFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MessageDispatcherFactory factory = connector.getDispatcherFactory();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testConnectorMessageRequesterFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MessageRequesterFactory factory = connector.getRequesterFactory();
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testConnectorInitialise() throws Exception {
        Connector connector = this.getConnector();
        try {
            connector.initialise();
            Assert.fail((String)"A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract Connector createConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();
}

