/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

public class TransformerWeightingTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testExactMatch() throws Exception {
        DummyTransformer trans = new DummyTransformer();
        trans.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        trans.registerSourceType(DataTypeFactory.create(IOException.class));
        TransformerWeighting weighting = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans);
        Assert.assertFalse((boolean)weighting.isNotMatch());
        Assert.assertTrue((boolean)weighting.isExactMatch());
    }

    @Test
    public void testNearMatch() throws Exception {
        ObjectToByteArray trans = new ObjectToByteArray();
        TransformerWeighting weighting = new TransformerWeighting(FilterInputStream.class, byte[].class, (Transformer)trans);
        Assert.assertFalse((boolean)weighting.isNotMatch());
        Assert.assertFalse((boolean)weighting.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting.getOutputWeighting());
    }

    @Test
    public void testNoMatchWeighting() throws Exception {
        SerializableToByteArray trans = new SerializableToByteArray();
        TransformerWeighting weighting = new TransformerWeighting(FruitBowl.class, byte[].class, (Transformer)trans);
        Assert.assertTrue((boolean)weighting.isNotMatch());
        Assert.assertEquals((long)-1L, (long)weighting.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting.getOutputWeighting());
    }

    @Test
    public void testCompareWeightingWithNearMatches() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        trans2.registerSourceType(DataTypeFactory.create(Exception.class));
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertFalse((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertFalse((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)1L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }

    @Test
    public void testCompareWeightingWithExactMatch() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        trans2.registerSourceType(DataTypeFactory.create(IOException.class));
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertFalse((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertTrue((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }

    @Test
    public void testCompareWeightingWithNoMatch() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        trans2.registerSourceType(DataTypeFactory.create(FruitBowl.class));
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        Assert.assertFalse((boolean)weighting1.isNotMatch());
        Assert.assertTrue((boolean)weighting2.isNotMatch());
        Assert.assertFalse((boolean)weighting1.isExactMatch());
        Assert.assertFalse((boolean)weighting2.isExactMatch());
        Assert.assertEquals((long)-1L, (long)weighting2.compareTo((Object)weighting1));
        Assert.assertEquals((long)3L, (long)weighting1.getInputWeighting());
        Assert.assertEquals((long)-1L, (long)weighting2.getInputWeighting());
        Assert.assertEquals((long)0L, (long)weighting1.getOutputWeighting());
        Assert.assertEquals((long)0L, (long)weighting2.getOutputWeighting());
    }

    @Test
    public void testPriorityMatching() throws Exception {
        DummyTransformer t1 = new DummyTransformer();
        t1.setName("--t1");
        t1.registerSourceType(DataTypeFactory.create(Orange.class));
        t1.setReturnDataType(DataTypeFactory.create(Fruit.class));
        muleContext.getRegistry().registerTransformer((Transformer)t1);
        DummyTransformer t2 = new DummyTransformer();
        t2.setName("--t2");
        t2.registerSourceType(DataTypeFactory.OBJECT);
        t2.setReturnDataType(DataTypeFactory.create(Fruit.class));
        muleContext.getRegistry().registerTransformer((Transformer)t2);
        List trans = muleContext.getRegistry().lookupTransformers((DataType)new SimpleDataType(BloodOrange.class), (DataType)new SimpleDataType(Fruit.class));
        Assert.assertEquals((long)2L, (long)trans.size());
        for (Transformer transformer : trans) {
            Assert.assertTrue((boolean)transformer.getName().startsWith("--"));
        }
        Transformer result = muleContext.getRegistry().lookupTransformer((DataType)new SimpleDataType(BloodOrange.class), (DataType)new SimpleDataType(Fruit.class));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"--t1", (Object)result.getName());
    }

    private static class DummyTransformer
    extends AbstractTransformer
    implements DiscoverableTransformer {
        private int weighting;

        public int getPriorityWeighting() {
            return this.weighting;
        }

        public void setPriorityWeighting(int weighting) {
            this.weighting = weighting;
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return src;
        }
    }
}

