/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerChain;
import org.mule.transformer.types.DataTypeFactory;

public class TransformerChainingTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);

    @Test
    public void testSingleChainedTransformer() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    @Test
    public void testTwoChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer});
        message.applyTransformers(null, Collections.singletonList(messageTransformer));
        Object transformedMessage = message.getPayload();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(2), (Object)transformedMessage);
    }

    @Test
    public void testThreeChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer, validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(3), (Object)transformedMessage);
    }

    @Test
    public void testIgnoreBadInputDoesNotBreakChainWithTransformationOrderInvalidValid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(true);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    @Test
    public void testIgnoreBadInputBreaksChainWithTransformationOrderInvalidValid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        try {
            message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
            Assert.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException tfe) {
            // empty catch block
        }
    }

    @Test
    public void testIgnoreBadInputDoesNotBreakChainWithTransformationOrderValidInvalid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(true);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, invalidTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        Assert.assertNotNull((Object)transformedMessage);
        Assert.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    @Test
    public void testIgnoreBadInputBreaksChainWithTransformationOrderValidInvalid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        Assert.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        Assert.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), this.muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, invalidTransformer});
        try {
            message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
            Assert.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException tfe) {
            Assert.assertNotNull((Object)((Object)tfe));
        }
    }

    private Transformer getInvalidTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, String encoding) throws TransformerException {
                throw new RuntimeException("This transformer must not perform any transformations.");
            }
        };
        transformer.registerSourceType(DataTypeFactory.create(this.getClass()));
        return transformer;
    }

    private Transformer getIncreaseByOneTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, String encoding) throws TransformerException {
                return new Integer((Integer)src + 1);
            }
        };
        DataType integerDataType = DataTypeFactory.create(Integer.class);
        transformer.registerSourceType(integerDataType);
        transformer.setReturnDataType(integerDataType);
        return transformer;
    }
}

