/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.mule.tck.junit4.rule.FreePortFinder;

public class DynamicPort
extends ExternalResource {
    public static final String MIN_PORT_SYSTEM_PROPERTY = "mule.test.minPort";
    public static final String MAX_PORT_SYSTEM_PROPERTY = "mule.test.maxPort";
    private static final int DEFAULT_MIN_PORT = 5000;
    private static final int DEFAULT_MAX_PORT = 6000;
    protected static FreePortFinder freePortFinder;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final String name;
    private int number;
    private boolean initialized = false;

    public DynamicPort(String name) {
        this.name = name;
    }

    public void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("Dynamic port was already initialized");
        }
        this.number = freePortFinder.find();
        System.setProperty(this.name, String.valueOf(this.number));
        this.initialized = true;
    }

    public void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("Dynamic port was not initialized");
        }
        freePortFinder.releasePort(this.number);
        this.initialized = false;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    static {
        int minPort = 5000;
        int maxPort = 6000;
        String propertyValue = System.getProperty(MIN_PORT_SYSTEM_PROPERTY);
        if (propertyValue != null) {
            minPort = Integer.parseInt(propertyValue);
        }
        if ((propertyValue = System.getProperty(MAX_PORT_SYSTEM_PROPERTY)) != null) {
            maxPort = Integer.parseInt(propertyValue);
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException(String.format("Min port '%s' must be less than max port '%s'", minPort, maxPort));
        }
        freePortFinder = new FreePortFinder(minPort, maxPort);
    }
}

