/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.routing.MapSplitter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MapSplitterTestCase
extends AbstractMuleContextTestCase {
    private MapSplitter mapSplitter;
    private List<String> splitPayloads = new ArrayList<String>();
    private List<String> splitKeyProperties = new ArrayList<String>();

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.mapSplitter = new MapSplitter();
        this.mapSplitter.setMuleContext(muleContext);
        this.mapSplitter.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                MapSplitterTestCase.this.splitPayloads.add(event.getMessageAsString());
                MapSplitterTestCase.this.splitKeyProperties.add((String)event.getMessage().getProperty(MapSplitter.MAP_ENTRY_KEY, PropertyScope.INVOCATION));
                return event;
            }
        });
    }

    @Test
    public void testSplit() throws Exception {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("1", "one");
        testMap.put("2", "two");
        testMap.put("3", "three");
        this.mapSplitter.process(MapSplitterTestCase.getTestEvent(testMap));
        Assert.assertEquals((long)3L, (long)this.splitPayloads.size());
        Assert.assertTrue((boolean)this.splitPayloads.contains("one"));
        Assert.assertTrue((boolean)this.splitPayloads.contains("two"));
        Assert.assertTrue((boolean)this.splitPayloads.contains("three"));
        Assert.assertEquals((long)3L, (long)this.splitPayloads.size());
        Assert.assertEquals((Object)"1", (Object)this.splitKeyProperties.get(this.splitPayloads.indexOf("one")));
        Assert.assertEquals((Object)"2", (Object)this.splitKeyProperties.get(this.splitPayloads.indexOf("two")));
        Assert.assertEquals((Object)"3", (Object)this.splitKeyProperties.get(this.splitPayloads.indexOf("three")));
    }
}

