/*
 * Decompiled with CFR 0.152.
 */
package org.mule.process;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.process.ProcessingCallback;
import org.mule.process.ProcessingTemplate;
import org.mule.process.TransactionalErrorHandlingProcessingTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionalProcessingTemplateTestCase
extends AbstractMuleTestCase {
    protected MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    @Mock
    protected MuleEvent RETURN_VALUE;
    @Spy
    protected TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Spy
    protected TestTransaction mockNewTransaction = new TestTransaction(this.mockMuleContext);
    @Mock
    protected ExternalTransactionAwareTransactionFactory mockExternalTransactionFactory;
    @Mock
    protected MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleEvent mockEvent;
    @Mock
    protected MessagingExceptionHandler mockMessagingExceptionHandler;

    @Before
    public void unbindTransaction() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
    }

    @Test
    public void testActionIndifferentConfig() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(6);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNeverAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionNeverAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(5);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        processingTemplate.execute(this.getEmptyTransactionCallback());
    }

    @Test
    public void testActionNoneAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    @Test
    public void testActionNoneAndTxForCommit() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testActionNoneAndTxForRollback() throws Exception {
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
    }

    @Test
    public void testActionNoneAndXaTx() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)TransactionalProcessingTemplateTestCase.this.mockTransaction);
                return TransactionalProcessingTemplateTestCase.this.mockTransaction;
            }
        });
        this.mockTransaction.setXA(true);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionNoneAndWithExternalTransactionWithTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Transaction externalTransaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenReturn((Object)externalTransaction);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndCommitTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndRollbackTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndRollbackTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = processingTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndCommitNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndRollbackNewTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        Mockito.when((Object)this.mockTransaction.isRollbackOnly()).thenReturn((Object)true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        Object result = processingTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testActionAlwaysJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        processingTemplate.execute(this.getRollbackTransactionCallback());
    }

    @Test
    public void testActionAlwaysJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getRollbackTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionBeginOrJoinAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionBeginOrJoinAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(2);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockTransaction));
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionJoinIfPossibleAndNoTx() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testActionJoinIfPossibleAndTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(4);
        ProcessingTemplate processingTemplate = this.createProcessingTemplate(config);
        Object result = processingTemplate.execute(this.getEmptyTransactionCallback());
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    protected ProcessingTemplate createProcessingTemplate(MuleTransactionConfig config) {
        return new TransactionalErrorHandlingProcessingTemplate(this.mockMuleContext, (TransactionConfig)config, this.mockMessagingExceptionHandler);
    }

    protected ProcessingCallback getEmptyTransactionCallback() {
        return TransactionTemplateTestUtils.getEmptyTransactionCallback(this.RETURN_VALUE);
    }

    protected ProcessingCallback getRollbackTransactionCallback() {
        return TransactionTemplateTestUtils.getRollbackTransactionCallback(this.RETURN_VALUE);
    }
}

