/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.expression.MuleContextExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class MuleContextExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    @Override
    protected void doSetUp() throws Exception {
        MuleEvent event = MuleContextExpressionEvaluatorTestCase.getTestEvent((Object)"testing", MuleContextExpressionEvaluatorTestCase.getTestService("apple", Apple.class), MuleContextExpressionEvaluatorTestCase.getTestInboundEndpoint("test", "test://foo"));
        RequestContext.setEvent((MuleEvent)event);
    }

    @Test
    public void testExpressions() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleContextExpressionEvaluator extractor = new MuleContextExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("serviceName", (MuleMessage)message);
        Assert.assertEquals((Object)"apple", (Object)o);
        o = extractor.evaluate("modelName", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("inboundEndpoint", (MuleMessage)message);
        Assert.assertEquals((Object)"test://foo", (Object)o.toString());
        o = extractor.evaluate("serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("clusterId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("domainId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = extractor.evaluate("workingDir", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            o = extractor.evaluate("bork", (MuleMessage)message);
            Assert.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testExpressionsFromExtractorManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object o = muleContext.getExpressionManager().evaluate("context:serviceName", (MuleMessage)message);
        Assert.assertEquals((Object)"apple", (Object)o);
        o = muleContext.getExpressionManager().evaluate("context:modelName", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("context:inboundEndpoint", (MuleMessage)message);
        Assert.assertEquals((Object)"test://foo", (Object)o.toString());
        o = muleContext.getExpressionManager().evaluate("context:serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("context:clusterId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("context:domainId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("context:workingDir", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            o = muleContext.getExpressionManager().evaluate("context:bork", (MuleMessage)message);
            Assert.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMissingEventContext() throws Exception {
        RequestContext.clear();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleContextExpressionEvaluator extractor = new MuleContextExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("serverId", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        try {
            o = extractor.evaluate("serviceName", (MuleMessage)message);
            Assert.fail((String)"There is no current event context");
        }
        catch (MuleRuntimeException e) {
            // empty catch block
        }
    }
}

