/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.routing.correlation.CorrelationPropertiesExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.UUID;

public class CorrelationPropertiesExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private HashMap<String, Object> messageProperties;
    private CorrelationPropertiesExpressionEvaluator evaluator = new CorrelationPropertiesExpressionEvaluator();
    private DefaultMuleMessage message;

    public CorrelationPropertiesExpressionEvaluatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    public void doSetUp() {
        this.messageProperties = new HashMap(3);
        this.messageProperties.put("foo", "foovalue");
        this.messageProperties.put("bar", "barvalue");
        this.messageProperties.put("baz", "bazvalue");
        this.message = new DefaultMuleMessage((Object)"Test Message", this.messageProperties, muleContext);
    }

    @Test
    public void testCorrelationManagerCorrelationId() {
        String correlationId = UUID.getUUID();
        this.message.setCorrelationId(correlationId);
        Object result = this.evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)correlationId, (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCorrelationManagerNullResult() {
        this.message.setUniqueId(null);
        this.evaluator.evaluate("MULE_CORRELATION_ID", (MuleMessage)this.message);
    }

    @Test
    public void testCorrelationManagerUniqueId() {
        Object result = this.evaluator.evaluate("MULE_MESSAGE_ID", (MuleMessage)this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.message.getUniqueId(), (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCorrelationManagerInvalidKey() {
        this.evaluator.evaluate("invalid-key", (MuleMessage)this.message);
    }
}

