/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.tanukisoftware.wrapper.jmx.WrapperManager;
import org.tanukisoftware.wrapper.jmx.WrapperManagerMBean;

public class ManagementUtils {
    protected static JmxSupportFactory jmxSupportFactory;
    protected static JmxSupport jmxSupport;

    public static void restart() throws Exception {
        WrapperManagerMBean proxy = ManagementUtils.getProxy();
        if (proxy == null) {
            throw new RuntimeException("The wrapper is not enabled.");
        }
        proxy.restart();
    }

    protected static synchronized WrapperManagerMBean getProxy() throws MalformedObjectNameException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (jmxSupport == null) {
            jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
            jmxSupport = jmxSupportFactory.getJmxSupport();
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String jmxNameForMule = String.format("%s:%s", "Mule", "name=WrapperManager");
        ObjectName on = jmxSupport.getObjectName(jmxNameForMule);
        if (!mBeanServer.isRegistered(on)) {
            mBeanServer.registerMBean(new WrapperManager(), on);
        }
        WrapperManagerMBean proxy = MBeanServerInvocationHandler.newProxyInstance(mBeanServer, on, WrapperManagerMBean.class, false);
        return proxy;
    }
}

