/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mp4parser.aspectj.lang.JoinPoint;
import org.mp4parser.aspectj.lang.Signature;
import org.mp4parser.aspectj.runtime.internal.Conversions;
import org.mp4parser.aspectj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeReaderVariable;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.IsoTypeWriterVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackFragmentRandomAccessBox
extends AbstractFullBox {
    public static final String TYPE = "tfra";
    private long trackId;
    private int reserved;
    private int lengthSizeOfTrafNum = 2;
    private int lengthSizeOfTrunNum = 2;
    private int lengthSizeOfSampleNum = 2;
    private List<Entry> entries = Collections.emptyList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public TrackFragmentRandomAccessBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        contentSize += 12L;
        contentSize = this.getVersion() == 1 ? (contentSize += (long)(16 * this.entries.size())) : (contentSize += (long)(8 * this.entries.size()));
        contentSize += (long)(this.lengthSizeOfTrafNum * this.entries.size());
        contentSize += (long)(this.lengthSizeOfTrunNum * this.entries.size());
        return contentSize += (long)(this.lengthSizeOfSampleNum * this.entries.size());
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.trackId = IsoTypeReader.readUInt32(content);
        long temp = IsoTypeReader.readUInt32(content);
        this.reserved = (int)(temp >> 6);
        this.lengthSizeOfTrafNum = ((int)(temp & 0x3FL) >> 4) + 1;
        this.lengthSizeOfTrunNum = ((int)(temp & 0xCL) >> 2) + 1;
        this.lengthSizeOfSampleNum = (int)(temp & 3L) + 1;
        long numberOfEntries = IsoTypeReader.readUInt32(content);
        this.entries = new ArrayList<Entry>();
        int i = 0;
        while ((long)i < numberOfEntries) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.time = IsoTypeReader.readUInt64(content);
                entry.moofOffset = IsoTypeReader.readUInt64(content);
            } else {
                entry.time = IsoTypeReader.readUInt32(content);
                entry.moofOffset = IsoTypeReader.readUInt32(content);
            }
            entry.trafNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfTrafNum);
            entry.trunNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfTrunNum);
            entry.sampleNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfSampleNum);
            this.entries.add(entry);
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.trackId);
        long temp = this.reserved << 6;
        temp |= (long)((this.lengthSizeOfTrafNum - 1 & 3) << 4);
        temp |= (long)((this.lengthSizeOfTrunNum - 1 & 3) << 2);
        IsoTypeWriter.writeUInt32(byteBuffer, temp |= (long)(this.lengthSizeOfSampleNum - 1 & 3));
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                IsoTypeWriter.writeUInt64(byteBuffer, entry.time);
                IsoTypeWriter.writeUInt64(byteBuffer, entry.moofOffset);
            } else {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.time);
                IsoTypeWriter.writeUInt32(byteBuffer, entry.moofOffset);
            }
            IsoTypeWriterVariable.write(entry.trafNumber, byteBuffer, this.lengthSizeOfTrafNum);
            IsoTypeWriterVariable.write(entry.trunNumber, byteBuffer, this.lengthSizeOfTrunNum);
            IsoTypeWriterVariable.write(entry.sampleNumber, byteBuffer, this.lengthSizeOfSampleNum);
        }
    }

    public long getTrackId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.trackId;
    }

    public void setTrackId(long trackId) {
        long l = trackId;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.trackId = trackId;
    }

    public int getReserved() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.reserved;
    }

    public int getLengthSizeOfTrafNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfTrafNum;
    }

    public void setLengthSizeOfTrafNum(int lengthSizeOfTrafNum) {
        int n = lengthSizeOfTrafNum;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfTrafNum = lengthSizeOfTrafNum;
    }

    public int getLengthSizeOfTrunNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfTrunNum;
    }

    public void setLengthSizeOfTrunNum(int lengthSizeOfTrunNum) {
        int n = lengthSizeOfTrunNum;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfTrunNum = lengthSizeOfTrunNum;
    }

    public int getLengthSizeOfSampleNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfSampleNum;
    }

    public void setLengthSizeOfSampleNum(int lengthSizeOfSampleNum) {
        int n = lengthSizeOfSampleNum;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfSampleNum = lengthSizeOfSampleNum;
    }

    public long getNumberOfEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "TrackFragmentRandomAccessBox{trackId=" + this.trackId + ", entries=" + this.entries + '}';
    }

    static {
        TrackFragmentRandomAccessBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackFragmentRandomAccessBox.java", TrackFragmentRandomAccessBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTrackId", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "long"), 125);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTrackId", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "long", "trackId", "", "void"), 129);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "java.util.List"), 165);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "java.util.List", "entries", "", "void"), 169);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "java.lang.String"), 174);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReserved", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "int"), 133);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfTrafNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "int"), 137);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfTrafNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "int", "lengthSizeOfTrafNum", "", "void"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfTrunNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "int"), 145);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfTrunNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "int", "lengthSizeOfTrunNum", "", "void"), 149);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfSampleNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "int"), 153);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfSampleNum", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "int", "lengthSizeOfSampleNum", "", "void"), 157);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOfEntries", "org.mp4parser.boxes.iso14496.part12.TrackFragmentRandomAccessBox", "", "", "", "long"), 161);
    }

    public static class Entry {
        private long time;
        private long moofOffset;
        private long trafNumber;
        private long trunNumber;
        private long sampleNumber;

        public Entry() {
        }

        public Entry(long time, long moofOffset, long trafNumber, long trunNumber, long sampleNumber) {
            this.moofOffset = moofOffset;
            this.sampleNumber = sampleNumber;
            this.time = time;
            this.trafNumber = trafNumber;
            this.trunNumber = trunNumber;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getMoofOffset() {
            return this.moofOffset;
        }

        public void setMoofOffset(long moofOffset) {
            this.moofOffset = moofOffset;
        }

        public long getTrafNumber() {
            return this.trafNumber;
        }

        public void setTrafNumber(long trafNumber) {
            this.trafNumber = trafNumber;
        }

        public long getTrunNumber() {
            return this.trunNumber;
        }

        public void setTrunNumber(long trunNumber) {
            this.trunNumber = trunNumber;
        }

        public long getSampleNumber() {
            return this.sampleNumber;
        }

        public void setSampleNumber(long sampleNumber) {
            this.sampleNumber = sampleNumber;
        }

        public String toString() {
            return "Entry{time=" + this.time + ", moofOffset=" + this.moofOffset + ", trafNumber=" + this.trafNumber + ", trunNumber=" + this.trunNumber + ", sampleNumber=" + this.sampleNumber + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.moofOffset != entry.moofOffset) {
                return false;
            }
            if (this.sampleNumber != entry.sampleNumber) {
                return false;
            }
            if (this.time != entry.time) {
                return false;
            }
            if (this.trafNumber != entry.trafNumber) {
                return false;
            }
            return this.trunNumber == entry.trunNumber;
        }

        public int hashCode() {
            int result = (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (int)(this.moofOffset ^ this.moofOffset >>> 32);
            result = 31 * result + (int)(this.trafNumber ^ this.trafNumber >>> 32);
            result = 31 * result + (int)(this.trunNumber ^ this.trunNumber >>> 32);
            result = 31 * result + (int)(this.sampleNumber ^ this.sampleNumber >>> 32);
            return result;
        }
    }
}

