/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private static Logger log = Logger.getLogger(JspFactoryImpl.class.getName());
    private static final String SPEC_VERSION = "2.1";
    private static final boolean USE_POOL = Boolean.getBoolean("org.apache.jasper.runtime.JspFactoryImpl.USE_POOL");
    private ThreadLocal<LinkedList<PageContext>> pool = new ThreadLocal<LinkedList<PageContext>>(){

        @Override
        protected synchronized LinkedList<PageContext> initialValue() {
            return new LinkedList<PageContext>();
        }
    };

    @Override
    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetPageContext dp = new PrivilegedGetPageContext(this, servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return AccessController.doPrivileged(dp);
        }
        return this.internalGetPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
    }

    @Override
    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedReleasePageContext dp = new PrivilegedReleasePageContext(this, pc);
            AccessController.doPrivileged(dp);
        } else {
            this.internalReleasePageContext(pc);
        }
    }

    @Override
    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            @Override
            public String getSpecificationVersion() {
                return JspFactoryImpl.SPEC_VERSION;
            }
        };
    }

    @Override
    public JspApplicationContext getJspApplicationContext(ServletContext context) {
        return JspApplicationContextImpl.findJspApplicationContext(context);
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        try {
            PageContext pc = null;
            if (USE_POOL) {
                LinkedList<PageContext> pcPool = this.pool.get();
                if (!pcPool.isEmpty()) {
                    pc = pcPool.removeFirst();
                }
                if (pc == null) {
                    pc = new PageContextImpl(this);
                }
            } else {
                pc = new PageContextImpl(this);
            }
            ((PageContext)pc).initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return pc;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Exception initializing page context", ex);
            return null;
        }
    }

    private void internalReleasePageContext(PageContext pc) {
        pc.release();
        if (USE_POOL && pc instanceof PageContextImpl) {
            LinkedList<PageContext> pcPool = this.pool.get();
            pcPool.addFirst(pc);
        }
    }

    private class PrivilegedReleasePageContext
    implements PrivilegedAction<Object> {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl factory, PageContext pageContext) {
            this.factory = factory;
            this.pageContext = pageContext;
        }

        @Override
        public Object run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private class PrivilegedGetPageContext
    implements PrivilegedAction<PageContext> {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl factory, Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
            this.factory = factory;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.errorPageURL = errorPageURL;
            this.needsSession = needsSession;
            this.bufferSize = bufferSize;
            this.autoflush = autoflush;
        }

        @Override
        public PageContext run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

