/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.UserRealm;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.plugin.AbstractJettyRunMojo;
import org.mortbay.jetty.plugin.Jetty6PluginServer;
import org.mortbay.jetty.plugin.util.JettyPluginServer;
import org.mortbay.xml.XmlConfiguration;

public class Jetty6RunMojo
extends AbstractJettyRunMojo {
    private Connector[] connectors;
    private ContextHandler[] contextHandlers;
    private UserRealm[] userRealms;
    private RequestLog requestLog;

    public Object getConfiguredRequestLog() {
        return this.requestLog;
    }

    public Object[] getConfiguredConnectors() {
        return this.connectors;
    }

    public Object[] getConfiguredUserRealms() {
        return this.userRealms;
    }

    public ContextHandler[] getConfiguredContextHandlers() {
        return this.contextHandlers;
    }

    public JettyPluginServer createServer() {
        return new Jetty6PluginServer();
    }

    public void finishConfigurationBeforeStart() throws Exception {
        ContextHandler[] handlers = this.getConfiguredContextHandlers();
        JettyPluginServer plugin = this.getServer();
        Server server = (Server)plugin.getProxiedObject();
        HandlerCollection contexts = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            contexts.addHandler((Handler)handlers[i]);
        }
    }

    public void applyJettyXml() throws Exception {
        if (this.getJettyXmlFile() == null) {
            return;
        }
        this.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + this.getJettyXmlFile()));
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getJettyXmlFile().toURL());
        xmlConfiguration.configure(this.getServer().getProxiedObject());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

