/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Client;
import dojox.cometd.Listener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
implements Client {
    private String _id;
    private String _type;
    private Queue<Map<String, Object>> _messageQ = new LinkedList<Map<String, Object>>();
    private AtomicInteger _responsesPending = new AtomicInteger(0);
    private ChannelImpl _connection = null;
    private ChannelImpl[] _subscriptions = new ChannelImpl[0];
    private boolean _JSONCommented;
    private Listener _listener;
    protected AbstractBayeux _bayeux;
    private String _browserId;
    private String _connectedBrowserId;
    private int _connectedCount;

    protected ClientImpl(AbstractBayeux bayeux, String idPrefix, Listener listener) {
        this._bayeux = bayeux;
        this._id = idPrefix == null ? Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36) : idPrefix + "_" + Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36);
        this._bayeux._clients.put(this.getId(), this);
        if (this._bayeux.isLogInfo()) {
            this._bayeux.logInfo("newClient: " + this);
        }
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelImpl connect() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            String connection_id = "/meta/connections/" + this.getId();
            this._connection = (ChannelImpl)this._bayeux.getChannel(connection_id, true);
            this._connection.subscribe(this);
            return this._connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Client from, Map<String, Object> message) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._connection != null) {
                this._messageQ.add(message);
                if (this._bayeux.getAlwaysResumePoll() || this._responsesPending.get() < 1) {
                    this.resume();
                }
            }
            if (this._listener != null) {
                this._listener.deliver(from, (String)message.get("channel"), message.get("data"), (String)message.get("id"));
            }
        }
    }

    public ChannelImpl getConnection() {
        return this._connection;
    }

    public String getConnectionType() {
        return this._type;
    }

    @Override
    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return this._messageQ.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJSONCommented() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            return this._JSONCommented;
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void remove(boolean timeout) {
        this._bayeux.removeClient(this._id);
        if (this._listener != null) {
            this._listener.removed(this._id, timeout);
        }
        this.onBrowser(null);
        this.resume();
    }

    public int responded() {
        return this._responsesPending.getAndDecrement();
    }

    public int responsePending() {
        return this._responsesPending.incrementAndGet();
    }

    public void resume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJSONCommented(boolean commented) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._JSONCommented = commented;
        }
    }

    @Override
    public void setListener(Listener listener) {
        this._listener = listener;
    }

    @Override
    public Listener getListener() {
        return this._listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Map<String, Object>> takeMessages() {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            if (this._messageQ.size() == 0) {
                return null;
            }
            Queue<Map<String, Object>> messages = this._messageQ;
            this._messageQ = new LinkedList<Map<String, Object>>();
            return messages;
        }
    }

    public String toString() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.addToArray((Object[])this._subscriptions, (Object)channel, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(ChannelImpl channel) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._subscriptions = (ChannelImpl[])LazyList.removeFromArray((Object[])this._subscriptions, (Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionType(String type) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(String _id) {
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._id = _id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        ChannelImpl[] subscriptions;
        ClientImpl clientImpl = this;
        synchronized (clientImpl) {
            this._messageQ.clear();
            subscriptions = this._subscriptions;
            this._subscriptions = new ChannelImpl[0];
        }
        for (ChannelImpl channel : subscriptions) {
            channel.unsubscribe(this);
        }
    }

    public void setBrowserId(String id) {
        this._browserId = id;
    }

    public String getBrowserId() {
        return this._browserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int onBrowser(String browserId) {
        Set<String> clients = null;
        if (this._connectedBrowserId != null) {
            assert (browserId == null || browserId.equals(this._connectedBrowserId));
            if (browserId == null) {
                Object object = this._bayeux._browserPolls;
                synchronized (object) {
                    clients = this._bayeux._browserPolls.get(this._connectedBrowserId);
                }
                object = clients;
                synchronized (object) {
                    clients.remove(this.getId());
                    this._connectedCount = clients.size();
                }
                this._connectedBrowserId = null;
            }
        } else if (browserId != null) {
            this._connectedBrowserId = browserId;
            Object object = this._bayeux._browserPolls;
            synchronized (object) {
                clients = this._bayeux._browserPolls.get(browserId);
                if (clients == null) {
                    clients = new HashSet<String>();
                    this._bayeux._browserPolls.put(browserId, clients);
                }
            }
            object = clients;
            synchronized (object) {
                clients.add(this.getId());
                this._connectedCount = clients.size();
            }
        }
        return this._connectedCount;
    }
}

