/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.EventHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.connection.ServerMonitor;
import com.mongodb.internal.connection.ServerTypeHelper;
import com.mongodb.internal.connection.TopologyVersionHelper;

@ThreadSafe
final class DefaultSdamServerDescriptionManager
implements SdamServerDescriptionManager {
    private final Cluster cluster;
    private final ServerId serverId;
    private final ServerListener serverListener;
    private final ServerMonitor serverMonitor;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode connectionMode;
    private volatile ServerDescription description;

    DefaultSdamServerDescriptionManager(Cluster cluster, ServerId serverId, ServerListener serverListener, ServerMonitor serverMonitor, ConnectionPool connectionPool, ClusterConnectionMode connectionMode) {
        this.cluster = cluster;
        this.serverId = Assertions.assertNotNull(serverId);
        this.serverListener = Assertions.assertNotNull(serverListener);
        this.serverMonitor = Assertions.assertNotNull(serverMonitor);
        this.connectionPool = Assertions.assertNotNull(connectionPool);
        this.connectionMode = Assertions.assertNotNull(connectionMode);
        this.description = ServerDescriptionHelper.unknownConnectingServerDescription(serverId, null);
    }

    @Override
    public void monitorUpdate(ServerDescription candidateDescription) {
        this.cluster.withLock(() -> {
            if (TopologyVersionHelper.newer(this.description.getTopologyVersion(), candidateDescription.getTopologyVersion())) {
                return;
            }
            ServerType newServerType = candidateDescription.getType();
            boolean markedPoolReady = false;
            if (ServerTypeHelper.isDataBearing(newServerType) || newServerType != ServerType.UNKNOWN && this.connectionMode == ClusterConnectionMode.SINGLE) {
                this.connectionPool.ready();
                markedPoolReady = true;
            }
            this.updateDescription(candidateDescription);
            Throwable candidateDescriptionException = candidateDescription.getException();
            if (candidateDescriptionException != null) {
                Assertions.assertTrue(newServerType == ServerType.UNKNOWN);
                Assertions.assertFalse(markedPoolReady);
                this.connectionPool.invalidate(candidateDescriptionException);
            }
        });
    }

    @Override
    public void updateToUnknown(ServerDescription candidateDescription) {
        Assertions.assertTrue(candidateDescription.getType() == ServerType.UNKNOWN);
        this.cluster.withLock(() -> {
            if (TopologyVersionHelper.newer(this.description.getTopologyVersion(), candidateDescription.getTopologyVersion())) {
                return;
            }
            this.updateDescription(candidateDescription);
        });
    }

    @Override
    public void handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue sdamIssue) {
        this.cluster.withLock(() -> this.handleException(sdamIssue, true));
    }

    @Override
    public void handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue sdamIssue) {
        this.cluster.withLock(() -> this.handleException(sdamIssue, false));
    }

    @Override
    public SdamServerDescriptionManager.SdamIssue.Context context() {
        return new SdamServerDescriptionManager.SdamIssue.Context(this.serverId, this.connectionPool.getGeneration(), this.description.getMaxWireVersion());
    }

    @Override
    public SdamServerDescriptionManager.SdamIssue.Context context(InternalConnection connection) {
        return new SdamServerDescriptionManager.SdamIssue.Context(this.serverId, connection.getGeneration(), connection.getDescription().getMaxWireVersion());
    }

    private void updateDescription(ServerDescription newDescription) {
        ServerDescription previousDescription = this.description;
        this.description = newDescription;
        ServerDescriptionChangedEvent serverDescriptionChangedEvent = new ServerDescriptionChangedEvent(this.serverId, newDescription, previousDescription);
        if (!EventHelper.wouldDescriptionsGenerateEquivalentEvents(newDescription, previousDescription)) {
            this.serverListener.serverDescriptionChanged(serverDescriptionChangedEvent);
        }
        this.cluster.onChange(serverDescriptionChangedEvent);
    }

    private void handleException(SdamServerDescriptionManager.SdamIssue sdamIssue, boolean beforeHandshake) {
        if (sdamIssue.stale(this.connectionPool, this.description)) {
            return;
        }
        if (sdamIssue.relatedToStateChange()) {
            this.updateDescription(sdamIssue.serverDescription());
            if (sdamIssue.relatedToShutdown()) {
                this.connectionPool.invalidate(sdamIssue.exception().orElse(null));
            }
            this.serverMonitor.connect();
        } else if (sdamIssue.relatedToNetworkNotTimeout() || beforeHandshake && (sdamIssue.relatedToNetworkTimeout() || sdamIssue.relatedToAuth())) {
            this.updateDescription(sdamIssue.serverDescription());
            this.connectionPool.invalidate(sdamIssue.exception().orElse(null));
            this.serverMonitor.cancelCurrentCheck();
        } else if (sdamIssue.relatedToWriteConcern() || sdamIssue.relatedToStalePrimary()) {
            this.updateDescription(sdamIssue.serverDescription());
            this.serverMonitor.connect();
        }
    }
}

