/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCredential;
import com.mongodb.MongoInternalException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;

public abstract class Authenticator {
    private final MongoCredentialWithCache credential;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    Authenticator(@NonNull MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this.credential = credential;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
    }

    public static boolean shouldAuthenticate(@Nullable Authenticator authenticator, ConnectionDescription connectionDescription) {
        return authenticator != null && connectionDescription.getServerType() != ServerType.REPLICA_SET_ARBITER;
    }

    @NonNull
    MongoCredentialWithCache getMongoCredentialWithCache() {
        return this.credential;
    }

    @NonNull
    MongoCredential getMongoCredential() {
        return this.credential.getCredential();
    }

    ClusterConnectionMode getClusterConnectionMode() {
        return this.clusterConnectionMode;
    }

    @Nullable
    ServerApi getServerApi() {
        return this.serverApi;
    }

    @NonNull
    String getUserNameNonNull() {
        String userName = this.credential.getCredential().getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    char[] getPasswordNonNull() {
        char[] password = this.credential.getCredential().getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    @NonNull
    <T> T getNonNullMechanismProperty(String key, @Nullable T defaultValue) {
        T mechanismProperty = this.credential.getCredential().getMechanismProperty(key, defaultValue);
        if (mechanismProperty == null) {
            throw new MongoInternalException("Mechanism property can not be null");
        }
        return mechanismProperty;
    }

    abstract void authenticate(InternalConnection var1, ConnectionDescription var2, OperationContext var3);

    abstract void authenticateAsync(InternalConnection var1, ConnectionDescription var2, OperationContext var3, SingleResultCallback<Void> var4);

    public void reauthenticate(InternalConnection connection, OperationContext operationContext) {
        this.authenticate(connection, connection.getDescription(), Authenticator.operationContextWithoutSession(operationContext));
    }

    public void reauthenticateAsync(InternalConnection connection, OperationContext operationContext, SingleResultCallback<Void> callback) {
        AsyncRunnable.beginAsync().thenRun(c -> this.authenticateAsync(connection, connection.getDescription(), Authenticator.operationContextWithoutSession(operationContext), c)).finish(callback);
    }

    static OperationContext operationContextWithoutSession(OperationContext operationContext) {
        return operationContext.withSessionContext(new ReadConcernAwareNoOpSessionContext(operationContext.getSessionContext().getReadConcern()));
    }
}

