/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public final class GridFSFileCodec
implements Codec<GridFSFile> {
    private static final List<String> VALID_FIELDS = Arrays.asList("_id", "filename", "length", "chunkSize", "uploadDate", "md5", "metadata");
    private final Codec<Document> documentCodec;
    private final Codec<BsonDocument> bsonDocumentCodec;

    public GridFSFileCodec(CodecRegistry registry) {
        this.documentCodec = Assertions.notNull("DocumentCodec", Assertions.notNull("registry", registry).get(Document.class));
        this.bsonDocumentCodec = Assertions.notNull("BsonDocumentCodec", registry.get(BsonDocument.class));
    }

    public GridFSFile decode(BsonReader reader, DecoderContext decoderContext) {
        BsonDocument bsonDocument = (BsonDocument)this.bsonDocumentCodec.decode(reader, decoderContext);
        BsonValue id = bsonDocument.get((Object)"_id");
        String filename = bsonDocument.getString((Object)"filename").getValue();
        long length = bsonDocument.getNumber((Object)"length").longValue();
        int chunkSize = bsonDocument.getNumber((Object)"chunkSize").intValue();
        Date uploadDate = new Date(bsonDocument.getDateTime((Object)"uploadDate").getValue());
        String md5 = bsonDocument.getString((Object)"md5").getValue();
        BsonDocument metadataBsonDocument = bsonDocument.getDocument((Object)"metadata", new BsonDocument());
        Document optionalMetadata = this.asDocumentOrNull(metadataBsonDocument);
        for (String key : VALID_FIELDS) {
            bsonDocument.remove((Object)key);
        }
        Document deprecatedExtraElements = this.asDocumentOrNull(bsonDocument);
        return new GridFSFile(id, filename, length, chunkSize, uploadDate, md5, optionalMetadata, deprecatedExtraElements);
    }

    public void encode(BsonWriter writer, GridFSFile value, EncoderContext encoderContext) {
        Document extraElements;
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("_id", value.getId());
        bsonDocument.put("filename", (BsonValue)new BsonString(value.getFilename()));
        bsonDocument.put("length", (BsonValue)new BsonInt64(value.getLength()));
        bsonDocument.put("chunkSize", (BsonValue)new BsonInt32(value.getChunkSize()));
        bsonDocument.put("uploadDate", (BsonValue)new BsonDateTime(value.getUploadDate().getTime()));
        bsonDocument.put("md5", (BsonValue)new BsonString(value.getMD5()));
        Document metadata = value.getMetadata();
        if (metadata != null) {
            bsonDocument.put("metadata", (BsonValue)new BsonDocumentWrapper((Object)metadata, this.documentCodec));
        }
        if ((extraElements = value.getExtraElements()) != null) {
            bsonDocument.putAll((Map)new BsonDocumentWrapper((Object)extraElements, this.documentCodec));
        }
        this.bsonDocumentCodec.encode(writer, (Object)bsonDocument, encoderContext);
    }

    public Class<GridFSFile> getEncoderClass() {
        return GridFSFile.class;
    }

    private Document asDocumentOrNull(BsonDocument bsonDocument) {
        if (bsonDocument.isEmpty()) {
            return null;
        }
        BsonDocumentReader reader = new BsonDocumentReader(bsonDocument);
        return (Document)this.documentCodec.decode((BsonReader)reader, DecoderContext.builder().build());
    }
}

