/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.tools.ToolProvider;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.mockito.Incubating;
import org.mockito.creation.instance.InstantiationException;
import org.mockito.creation.instance.Instantiator;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.base.MockitoInitializationException;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.ClassCreatingMockMaker;
import org.mockito.internal.creation.bytebuddy.InlineBytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.TypeCachingBytecodeGenerator;
import org.mockito.internal.util.Platform;
import org.mockito.internal.util.StringUtil;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;

@Incubating
public class InlineByteBuddyMockMaker
implements ClassCreatingMockMaker {
    private static final Instrumentation INSTRUMENTATION;
    private static final Throwable INITIALIZATION_ERROR;
    private final BytecodeGenerator bytecodeGenerator;
    private final WeakConcurrentMap<Object, MockMethodInterceptor> mocks = new WeakConcurrentMap.WithInlinedExpunction<Object, MockMethodInterceptor>();

    public InlineByteBuddyMockMaker() {
        if (INITIALIZATION_ERROR != null) {
            throw new MockitoInitializationException(StringUtil.join("Could not initialize inline Byte Buddy mock maker. (This mock maker is not supported on Android.)", ToolProvider.getSystemJavaCompiler() == null ? "Are you running a JRE instead of a JDK? The inline mock maker needs to be run on a JDK.\n" : "", Platform.describe()), INITIALIZATION_ERROR);
        }
        this.bytecodeGenerator = new TypeCachingBytecodeGenerator(new InlineBytecodeGenerator(INSTRUMENTATION, this.mocks), true);
    }

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Class<T> type = this.createMockType(settings);
        Instantiator instantiator = Plugins.getInstantiatorProvider().getInstantiator(settings);
        try {
            T instance = instantiator.newInstance(type);
            MockMethodInterceptor mockMethodInterceptor = new MockMethodInterceptor(handler, settings);
            this.mocks.put(instance, mockMethodInterceptor);
            if (instance instanceof MockAccess) {
                ((MockAccess)instance).setMockitoInterceptor(mockMethodInterceptor);
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new MockitoException("Unable to create mock instance of type '" + type.getSimpleName() + "'", e);
        }
    }

    @Override
    public <T> Class<? extends T> createMockType(MockCreationSettings<T> settings) {
        try {
            return this.bytecodeGenerator.mockClass(MockFeatures.withMockFeatures(settings.getTypeToMock(), settings.getExtraInterfaces(), settings.getSerializableMode(), settings.isStripAnnotations()));
        }
        catch (Exception bytecodeGenerationFailed) {
            throw this.prettifyFailure(settings, bytecodeGenerationFailed);
        }
    }

    private <T> RuntimeException prettifyFailure(MockCreationSettings<T> mockFeatures, Exception generationFailed) {
        if (mockFeatures.getTypeToMock().isArray()) {
            throw new MockitoException(StringUtil.join("Arrays cannot be mocked: " + mockFeatures.getTypeToMock() + ".", ""), generationFailed);
        }
        if (Modifier.isFinal(mockFeatures.getTypeToMock().getModifiers())) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + mockFeatures.getTypeToMock() + ".", "Can not mock final classes with the following settings :", " - explicit serialization (e.g. withSettings().serializable())", " - extra interfaces (e.g. withSettings().extraInterfaces(...))", "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", "", "Underlying exception : " + generationFailed), generationFailed);
        }
        if (Modifier.isPrivate(mockFeatures.getTypeToMock().getModifiers())) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + mockFeatures.getTypeToMock() + ".", "Most likely it is a private class that is not visible by Mockito", "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", ""), generationFailed);
        }
        throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + mockFeatures.getTypeToMock() + ".", "", "If you're not sure why you're getting this error, please report to the mailing list.", "", Platform.warnForVM("IBM J9 VM", "Early IBM virtual machine are known to have issues with Mockito, please upgrade to an up-to-date version.\n", "Hotspot", Platform.isJava8BelowUpdate45() ? "Java 8 early builds have bugs that were addressed in Java 1.8.0_45, please update your JDK!\n" : ""), Platform.describe(), "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", "", "Underlying exception : " + generationFailed), generationFailed);
    }

    @Override
    public MockHandler getHandler(Object mock) {
        MockMethodInterceptor interceptor = this.mocks.get(mock);
        if (interceptor == null) {
            return null;
        }
        return interceptor.handler;
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        MockMethodInterceptor mockMethodInterceptor = new MockMethodInterceptor(newHandler, settings);
        this.mocks.put(mock, mockMethodInterceptor);
        if (mock instanceof MockAccess) {
            ((MockAccess)mock).setMockitoInterceptor(mockMethodInterceptor);
        }
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            @Override
            public boolean mockable() {
                return INSTRUMENTATION.isModifiableClass(type) && !InlineBytecodeGenerator.EXCLUDES.contains(type);
            }

            @Override
            public String nonMockableReason() {
                if (this.mockable()) {
                    return "";
                }
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (InlineBytecodeGenerator.EXCLUDES.contains(type)) {
                    return "Cannot mock wrapper types, String.class or Class.class";
                }
                return "VM does not not support modification of given type";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Instrumentation instrumentation;
        Throwable initializationError = null;
        try {
            try {
                instrumentation = ByteBuddyAgent.install();
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalStateException(StringUtil.join("Byte Buddy requires retransformation for creating inline mocks. This feature is unavailable on the current VM.", "", "You cannot use this mock maker on this VM"));
                }
                File boot = File.createTempFile("mockitoboot", ".jar");
                boot.deleteOnExit();
                JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(boot));
                try {
                    String source = "org/mockito/internal/creation/bytebuddy/inject/MockMethodDispatcher";
                    InputStream inputStream = InlineByteBuddyMockMaker.class.getClassLoader().getResourceAsStream(source + ".raw");
                    if (inputStream == null) {
                        throw new IllegalStateException(StringUtil.join("The MockMethodDispatcher class file is not locatable: " + source + ".raw", "", "The class loader responsible for looking up the resource: " + InlineByteBuddyMockMaker.class.getClassLoader()));
                    }
                    outputStream.putNextEntry(new JarEntry(source + ".class"));
                    try {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    outputStream.closeEntry();
                }
                finally {
                    outputStream.close();
                }
                instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(boot));
                try {
                    Class.forName("org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher", false, null);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException(StringUtil.join("Mockito failed to inject the MockMethodDispatcher class into the bootstrap class loader", "", "It seems like your current VM does not support the instrumentation API correctly."), cnfe);
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException(StringUtil.join("Mockito could not self-attach a Java agent to the current VM. This feature is required for inline mocking.", "This error occured due to an I/O error during the creation of this agent: " + ioe, "", "Potentially, the current VM does not support the instrumentation API correctly"), ioe);
            }
        }
        catch (Throwable throwable) {
            instrumentation = null;
            initializationError = throwable;
        }
        INSTRUMENTATION = instrumentation;
        INITIALIZATION_ERROR = initializationError;
    }
}

