/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.listeners.StubbingLookupListener;
import org.mockito.internal.stubbing.StrictnessSelector;
import org.mockito.internal.stubbing.UnusedStubbingReporting;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Stubbing;

class DefaultStubbingLookupListener
implements StubbingLookupListener {
    private Strictness currentStrictness;
    private boolean mismatchesReported;

    DefaultStubbingLookupListener(Strictness strictness) {
        this.currentStrictness = strictness;
    }

    @Override
    public void onStubbingLookup(Invocation invocation, Stubbing stubbingFound, Collection<Stubbing> allStubbings, MockCreationSettings mockSettings) {
        Strictness actualStrictness = StrictnessSelector.determineStrictness(stubbingFound, mockSettings, this.currentStrictness);
        if (actualStrictness != Strictness.STRICT_STUBS) {
            return;
        }
        if (stubbingFound == null) {
            List<Invocation> argMismatchStubbings = DefaultStubbingLookupListener.potentialArgMismatches(invocation, allStubbings);
            if (!argMismatchStubbings.isEmpty()) {
                this.mismatchesReported = true;
                Reporter.potentialStubbingProblem(invocation, argMismatchStubbings);
            }
        } else {
            invocation.markVerified();
        }
    }

    private static List<Invocation> potentialArgMismatches(Invocation invocation, Collection<Stubbing> stubbings) {
        LinkedList<Invocation> matchingStubbings = new LinkedList<Invocation>();
        for (Stubbing s : stubbings) {
            if (!UnusedStubbingReporting.shouldBeReported(s) || !s.getInvocation().getMethod().getName().equals(invocation.getMethod().getName())) continue;
            matchingStubbings.add(s.getInvocation());
        }
        return matchingStubbings;
    }

    void setCurrentStrictness(Strictness currentStrictness) {
        this.currentStrictness = currentStrictness;
    }

    boolean isMismatchesReported() {
        return this.mismatchesReported;
    }
}

