/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;

public interface RealMethod
extends Serializable {
    public boolean isInvokable();

    public Object invoke() throws Throwable;

    public static class FromCallable
    implements RealMethod {
        private static final long serialVersionUID = 47957363950483625L;
        private final Callable<?> callable;

        public FromCallable(Callable<?> callable) {
            this.callable = callable;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            try {
                return this.callable.call();
            }
            catch (Throwable t) {
                new ConditionalStackTraceFilter().filter(t);
                throw t;
            }
        }
    }

    public static enum IsIllegal implements RealMethod
    {
        INSTANCE;


        @Override
        public boolean isInvokable() {
            return false;
        }

        @Override
        public Object invoke() {
            throw new IllegalStateException();
        }
    }
}

