/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.command;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.util.Assert;

public class InvocationRecord {
    private Command command;
    private Date time;
    private InetAddress clientHost;
    private Map data = new HashMap();
    private boolean locked = false;

    public InvocationRecord(Command command, InetAddress clientHost) {
        this.command = command;
        this.time = new Date();
        this.clientHost = clientHost;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public InetAddress getClientHost() {
        return this.clientHost;
    }

    public Command getCommand() {
        return this.command;
    }

    public Date getTime() {
        return new Date(this.time.getTime());
    }

    public void set(String key, Object value) {
        Assert.notNull(key, "key");
        Assert.isFalse(this.locked, "The InvocationRecord is locked!");
        this.data.put(key, value);
    }

    public boolean containsKey(String key) {
        Assert.notNull(key, "key");
        return this.data.containsKey(key);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public String getString(String key) {
        Assert.notNull(key, "key");
        return (String)this.data.get(key);
    }

    public Object getObject(String key) {
        Assert.notNull(key, "key");
        return this.data.get(key);
    }

    public String toString() {
        return "InvocationRecord[time=" + this.time + " client-host=" + this.clientHost + " command=" + this.command + " data=" + this.data + "]";
    }
}

