/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.PortParser;
import org.mockftpserver.stub.command.AbstractStubCommandHandler;

public class PortCommandHandler
extends AbstractStubCommandHandler
implements CommandHandler {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";

    public PortCommandHandler() {
        this.setReplyCode(200);
    }

    public void handleCommand(Command command, Session session, InvocationRecord invocationRecord) throws UnknownHostException {
        InetAddress host = PortParser.parseHost(command.getParameters());
        int port = PortParser.parsePortNumber(command.getParameters());
        this.LOG.debug((Object)("host=" + host + " port=" + port));
        session.setClientDataHost(host);
        session.setClientDataPort(port);
        invocationRecord.set(HOST_KEY, host);
        invocationRecord.set(PORT_KEY, new Integer(port));
        this.sendReply(session);
    }
}

