/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.text.SimpleDateFormat;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.filesystem.DirectoryListingFormatter;
import org.mockftpserver.fake.filesystem.FileSystemEntry;

public class WindowsDirectoryListingFormatter
implements DirectoryListingFormatter {
    private static final String DATE_FORMAT = "MM-dd-yy hh:mmaa";
    private static final int SIZE_WIDTH = 15;

    public String format(FileSystemEntry fileSystemEntry) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String dateStr = dateFormat.format(fileSystemEntry.getLastModified());
        String dirOrSize = fileSystemEntry.isDirectory() ? StringUtil.padRight("<DIR>", 15) : StringUtil.padLeft(Long.toString(fileSystemEntry.getSize()), 15);
        return dateStr + "  " + dirOrSize + "  " + fileSystemEntry.getName();
    }
}

