/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.util.Date;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.Permissions;

public abstract class AbstractFileSystemEntry
implements FileSystemEntry {
    private String path;
    private boolean pathLocked = false;
    private Date lastModified;
    private String owner;
    private String group;
    private Permissions permissions;

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public AbstractFileSystemEntry() {
    }

    public AbstractFileSystemEntry(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        int separatorIndex2;
        int separatorIndex1 = this.path.lastIndexOf(47);
        int separatorIndex = separatorIndex1 > (separatorIndex2 = this.path.lastIndexOf(92)) ? separatorIndex1 : separatorIndex2;
        return separatorIndex == -1 ? this.path : this.path.substring(separatorIndex + 1);
    }

    public void setPath(String path) {
        Assert.isFalse(this.pathLocked, "path is locked");
        this.path = path;
    }

    public void lockPath() {
        this.pathLocked = true;
    }

    public void setPermissionsFromString(String permissionsString) {
        this.permissions = new Permissions(permissionsString);
    }

    public abstract boolean isDirectory();
}

