/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NativeTypes {
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;
    private static final Set<Class<?>> NUMBER_TYPES;

    private NativeTypes() {
    }

    public static Class<?> getWrapperType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no primitive type.");
        }
        return PRIMITIVE_TO_WRAPPER_TYPES.get(clazz);
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no wrapper type.");
        }
        return WRAPPER_TO_PRIMITIVE_TYPES.get(clazz);
    }

    public static boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return NUMBER_TYPES.contains(clazz);
    }

    static {
        NUMBER_TYPES = new HashSet();
        HashMap<Class<Serializable>, Class<Serializable>> tmp = new HashMap<Class<Serializable>, Class<Serializable>>();
        tmp.put(Byte.class, Byte.TYPE);
        tmp.put(Short.class, Short.TYPE);
        tmp.put(Integer.class, Integer.TYPE);
        tmp.put(Long.class, Long.TYPE);
        tmp.put(Float.class, Float.TYPE);
        tmp.put(Double.class, Double.TYPE);
        tmp.put(Boolean.class, Boolean.TYPE);
        tmp.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE_TYPES = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(Byte.TYPE, Byte.class);
        tmp.put(Short.TYPE, Short.class);
        tmp.put(Integer.TYPE, Integer.class);
        tmp.put(Long.TYPE, Long.class);
        tmp.put(Float.TYPE, Float.class);
        tmp.put(Double.TYPE, Double.class);
        tmp.put(Boolean.TYPE, Boolean.class);
        tmp.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(tmp);
        NUMBER_TYPES.add(Byte.TYPE);
        NUMBER_TYPES.add(Short.TYPE);
        NUMBER_TYPES.add(Integer.TYPE);
        NUMBER_TYPES.add(Long.TYPE);
        NUMBER_TYPES.add(Float.TYPE);
        NUMBER_TYPES.add(Double.TYPE);
        NUMBER_TYPES.add(Byte.class);
        NUMBER_TYPES.add(Short.class);
        NUMBER_TYPES.add(Integer.class);
        NUMBER_TYPES.add(Long.class);
        NUMBER_TYPES.add(Float.class);
        NUMBER_TYPES.add(Double.class);
        NUMBER_TYPES.add(BigInteger.class);
        NUMBER_TYPES.add(BigDecimal.class);
    }
}

