/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class TargetReference {
    private final Parameter parameter;
    private final List<PropertyEntry> propertyEntries;
    private final boolean isValid;

    private TargetReference(Parameter sourceParameter, List<PropertyEntry> sourcePropertyEntries, boolean isValid) {
        this.parameter = sourceParameter;
        this.propertyEntries = sourcePropertyEntries;
        this.isValid = isValid;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public List<PropertyEntry> getPropertyEntries() {
        return this.propertyEntries;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<String> getElementNames() {
        ArrayList<String> elementNames = new ArrayList<String>();
        if (this.parameter != null) {
            elementNames.add(this.parameter.getName());
        }
        for (PropertyEntry propertyEntry : this.propertyEntries) {
            elementNames.add(propertyEntry.getName());
        }
        return elementNames;
    }

    public TargetReference pop() {
        if (this.propertyEntries.size() > 1) {
            ArrayList<PropertyEntry> newPropertyEntries = new ArrayList<PropertyEntry>(this.propertyEntries.size() - 1);
            for (PropertyEntry propertyEntry : this.propertyEntries) {
                PropertyEntry newPropertyEntry = propertyEntry.pop();
                if (newPropertyEntry == null) continue;
                newPropertyEntries.add(newPropertyEntry);
            }
            return new TargetReference(null, newPropertyEntries, this.isValid);
        }
        return null;
    }

    public static class BuilderFromTargetMapping {
        private Mapping mapping;
        private SourceMethod method;
        private FormattingMessager messager;
        private TypeFactory typeFactory;

        public BuilderFromTargetMapping messager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public BuilderFromTargetMapping mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public BuilderFromTargetMapping method(SourceMethod method) {
            this.method = method;
            return this;
        }

        public BuilderFromTargetMapping typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public BuilderFromTargetMapping isReverse(boolean isReverse) {
            return this;
        }

        public TargetReference build() {
            boolean foundEntryMatch;
            String[] targetPropertyNames;
            String targetName = this.mapping.getTargetName();
            if (targetName == null) {
                return null;
            }
            String[] segments = targetName.split("\\.");
            Parameter parameter = this.method.getMappingTargetParameter();
            Type resultType = this.method.getResultType();
            List<PropertyEntry> entries = this.getTargetEntries(resultType, targetPropertyNames = segments);
            boolean bl = foundEntryMatch = entries.size() == targetPropertyNames.length;
            if (!foundEntryMatch && segments.length > 1) {
                targetPropertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                entries = this.getTargetEntries(resultType, targetPropertyNames);
                foundEntryMatch = entries.size() == targetPropertyNames.length;
            }
            return new TargetReference(parameter, entries, foundEntryMatch);
        }

        private List<PropertyEntry> getTargetEntries(Type type, String[] entryNames) {
            CollectionMappingStrategyPrism cms = this.method.getMapperConfiguration().getCollectionMappingStrategy();
            ArrayList<PropertyEntry> targetEntries = new ArrayList<PropertyEntry>();
            Type nextType = type;
            for (int i = 0; i < entryNames.length; ++i) {
                Accessor targetReadAccessor = nextType.getPropertyReadAccessors().get(entryNames[i]);
                Accessor targetWriteAccessor = nextType.getPropertyWriteAccessors(cms).get(entryNames[i]);
                if (targetWriteAccessor == null || i < entryNames.length - 1 && targetReadAccessor == null) break;
                if (i != entryNames.length - 1 && !Executables.isSetterMethod(targetWriteAccessor)) continue;
                nextType = Executables.isGetterMethod(targetWriteAccessor) || Executables.isFieldAccessor(targetWriteAccessor) ? this.typeFactory.getReturnType((DeclaredType)nextType.getTypeMirror(), targetWriteAccessor) : this.typeFactory.getSingleParameter((DeclaredType)nextType.getTypeMirror(), targetWriteAccessor).getType();
                String[] fullName = Arrays.copyOfRange(entryNames, 0, i + 1);
                PropertyEntry propertyEntry = PropertyEntry.forTargetReference(fullName, targetReadAccessor, targetWriteAccessor, nextType);
                targetEntries.add(propertyEntry);
            }
            return targetEntries;
        }

        private void reportMappingError(Message msg, Object ... objects) {
            this.messager.printMessage((Element)this.method.getExecutable(), this.mapping.getMirror(), this.mapping.getSourceAnnotationValue(), msg, objects);
        }
    }
}

